/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;

public class GeyserMaterialInstance
implements MaterialInstance {
    private final String texture;
    private final String renderMethod;
    private final boolean faceDimming;
    private final boolean ambientOcclusion;

    GeyserMaterialInstance(MaterialInstanceBuilder builder) {
        this.texture = builder.texture;
        this.renderMethod = builder.renderMethod;
        this.faceDimming = builder.faceDimming;
        this.ambientOcclusion = builder.ambientOcclusion;
    }

    @Override
    public @Nullable String texture() {
        return this.texture;
    }

    @Override
    public @Nullable String renderMethod() {
        return this.renderMethod;
    }

    @Override
    public boolean faceDimming() {
        return this.faceDimming;
    }

    @Override
    public boolean ambientOcclusion() {
        return this.ambientOcclusion;
    }

    public GeyserMaterialInstance(String texture, String renderMethod, boolean faceDimming, boolean ambientOcclusion) {
        this.texture = texture;
        this.renderMethod = renderMethod;
        this.faceDimming = faceDimming;
        this.ambientOcclusion = ambientOcclusion;
    }

    public static class MaterialInstanceBuilder
    implements MaterialInstance.Builder {
        private String texture;
        private String renderMethod;
        private boolean faceDimming;
        private boolean ambientOcclusion;

        @Override
        public MaterialInstance.Builder texture(@Nullable String texture) {
            this.texture = texture;
            return this;
        }

        @Override
        public MaterialInstance.Builder renderMethod(@Nullable String renderMethod) {
            this.renderMethod = renderMethod;
            return this;
        }

        @Override
        public MaterialInstance.Builder faceDimming(boolean faceDimming) {
            this.faceDimming = faceDimming;
            return this;
        }

        @Override
        public MaterialInstance.Builder ambientOcclusion(boolean ambientOcclusion) {
            this.ambientOcclusion = ambientOcclusion;
            return this;
        }

        @Override
        public MaterialInstance build() {
            return new GeyserMaterialInstance(this);
        }
    }
}

