/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import com.github.steveice10.packetlib.helper.TransportHelper;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.BedrockPong;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.defaults.ConnectionTestCommand;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.event.type.GeyserBedrockPingEventImpl;
import org.geysermc.geyser.network.CIDRMatcher;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.network.GeyserServerInitializer;
import org.geysermc.geyser.network.netty.handler.RakConnectionRequestHandler;
import org.geysermc.geyser.network.netty.handler.RakPingHandler;
import org.geysermc.geyser.network.netty.proxy.ProxyServerHandler;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;

public final class GeyserServer {
    private static final boolean PRINT_DEBUG_PINGS = Boolean.parseBoolean(System.getProperty("Geyser.PrintPingsInDebugMode", "true"));
    private static final int MINECRAFT_VERSION_BYTES_LENGTH = GameProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion().getBytes(StandardCharsets.UTF_8).length;
    private static final int BRAND_BYTES_LENGTH = "Geyser".getBytes(StandardCharsets.UTF_8).length;
    private static final int MAGIC_RAKNET_LENGTH = 338;
    private static final Transport TRANSPORT = GeyserServer.compatibleTransport();
    private static final int SHUTDOWN_QUIET_PERIOD_MS = 100;
    private static final int SHUTDOWN_TIMEOUT_MS = 500;
    private final GeyserImpl geyser;
    private EventLoopGroup group;
    private final ServerBootstrap bootstrap;
    private EventLoopGroup playerGroup;
    private final ExpiringMap<InetSocketAddress, InetSocketAddress> proxiedAddresses;
    private ChannelFuture bootstrapFuture;

    public GeyserServer(GeyserImpl geyser, int threadCount) {
        this.geyser = geyser;
        this.group = TRANSPORT.eventLoopGroupFactory().apply(threadCount);
        this.bootstrap = this.createBootstrap(this.group);
        this.proxiedAddresses = this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? ExpiringMap.builder().expiration(31L, TimeUnit.MINUTES).expirationPolicy(ExpirationPolicy.ACCESSED).build() : null;
    }

    public CompletableFuture<Void> bind(InetSocketAddress address) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.bootstrapFuture = this.bootstrap.bind((SocketAddress)address).addListener(bindResult -> {
            if (bindResult.cause() != null) {
                future.completeExceptionally(bindResult.cause());
                return;
            }
            future.complete(null);
        });
        Channel channel = this.bootstrapFuture.channel();
        channel.pipeline().addFirst("rak-connection-request-handler", (ChannelHandler)new RakConnectionRequestHandler(this)).addAfter("rak-offline-handler", "rak-ping-handler", (ChannelHandler)new RakPingHandler(this));
        if (this.geyser.getConfig().getBedrock().isEnableProxyProtocol()) {
            channel.pipeline().addFirst("proxy-protocol-decoder", (ChannelHandler)new ProxyServerHandler());
        }
        return future;
    }

    public void shutdown() {
        try {
            Future future1 = this.group.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS);
            this.group = null;
            Future future2 = this.playerGroup.shutdownGracefully(100L, 500L, TimeUnit.MILLISECONDS);
            this.playerGroup = null;
            future1.sync();
            future2.sync();
            SkinProvider.shutdown();
        }
        catch (InterruptedException e) {
            GeyserImpl.getInstance().getLogger().severe("Exception in shutdown process", e);
        }
        this.bootstrapFuture.channel().closeFuture().syncUninterruptibly();
    }

    private ServerBootstrap createBootstrap(EventLoopGroup group) {
        if (this.geyser.getConfig().isDebugMode()) {
            this.geyser.getLogger().debug("EventLoop type: " + TRANSPORT.datagramChannel());
            if (TRANSPORT.datagramChannel() == NioDatagramChannel.class) {
                if (System.getProperties().contains("disableNativeEventLoop")) {
                    this.geyser.getLogger().debug("EventLoop type is NIO because native event loops are disabled.");
                } else {
                    this.geyser.getLogger().debug("Reason for no Epoll: " + GeyserServer.throwableOrCaught(() -> Epoll.unavailabilityCause()));
                    this.geyser.getLogger().debug("Reason for no KQueue: " + GeyserServer.throwableOrCaught(() -> KQueue.unavailabilityCause()));
                }
            }
        }
        GeyserServerInitializer serverInitializer = new GeyserServerInitializer(this.geyser);
        this.playerGroup = serverInitializer.getEventLoopGroup();
        this.geyser.getLogger().debug("Setting MTU to " + this.geyser.getConfig().getMtu());
        return ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(RakChannelFactory.server(TRANSPORT.datagramChannel()))).group(group).option(RakChannelOption.RAK_HANDLE_PING, (Object)true)).option(RakChannelOption.RAK_MAX_MTU, (Object)this.geyser.getConfig().getMtu())).childHandler((ChannelHandler)serverInitializer);
    }

    public boolean onConnectionRequest(InetSocketAddress inetSocketAddress) {
        List<String> allowedProxyIPs = this.geyser.getConfig().getBedrock().getProxyProtocolWhitelistedIPs();
        if (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() && !allowedProxyIPs.isEmpty()) {
            boolean isWhitelistedIP = false;
            for (CIDRMatcher matcher : this.geyser.getConfig().getBedrock().getWhitelistedIPsMatchers()) {
                if (!matcher.matches(inetSocketAddress.getAddress())) continue;
                isWhitelistedIP = true;
                break;
            }
            if (!isWhitelistedIP) {
                return false;
            }
        }
        String ip = this.geyser.getConfig().isLogPlayerIpAddresses() ? (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? this.proxiedAddresses.getOrDefault(inetSocketAddress, inetSocketAddress).toString() : inetSocketAddress.toString()) : "<IP address withheld>";
        this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.attempt_connect", ip));
        return true;
    }

    public BedrockPong onQuery(InetSocketAddress inetSocketAddress) {
        int subMotdLength;
        byte[] motdArray;
        IGeyserPingPassthrough pingPassthrough;
        if (this.geyser.getConfig().isDebugMode() && PRINT_DEBUG_PINGS) {
            String ip = this.geyser.getConfig().isLogPlayerIpAddresses() ? (this.geyser.getConfig().getBedrock().isEnableProxyProtocol() ? this.proxiedAddresses.getOrDefault(inetSocketAddress, inetSocketAddress).toString() : inetSocketAddress.toString()) : "<IP address withheld>";
            this.geyser.getLogger().debug(GeyserLocale.getLocaleStringLog("geyser.network.pinged", ip));
        }
        GeyserConfiguration config = this.geyser.getConfig();
        GeyserPingInfo pingInfo = null;
        if ((config.isPassthroughMotd() || config.isPassthroughPlayerCounts()) && (pingPassthrough = this.geyser.getBootstrap().getGeyserPingPassthrough()) != null) {
            pingInfo = pingPassthrough.getPingInformation(inetSocketAddress);
        }
        BedrockPong pong = new BedrockPong().edition("MCPE").gameType("Survival").nintendoLimited(false).protocolVersion(GameProtocol.DEFAULT_BEDROCK_CODEC.getProtocolVersion()).version(GameProtocol.DEFAULT_BEDROCK_CODEC.getMinecraftVersion()).ipv4Port(this.geyser.getConfig().getBedrock().port()).ipv6Port(this.geyser.getConfig().getBedrock().port()).serverId((Long)this.bootstrapFuture.channel().config().getOption(RakChannelOption.RAK_GUID));
        if (config.isPassthroughMotd() && pingInfo != null && pingInfo.getDescription() != null) {
            String[] motd = MessageTranslator.convertMessageLenient(pingInfo.getDescription()).split("\n");
            String mainMotd = motd.length > 0 ? motd[0] : config.getBedrock().primaryMotd();
            String subMotd = motd.length > 1 ? motd[1] : config.getBedrock().secondaryMotd();
            pong.motd(mainMotd.trim());
            pong.subMotd(subMotd.trim());
        } else {
            pong.motd(config.getBedrock().primaryMotd());
            pong.subMotd(config.getBedrock().secondaryMotd());
        }
        if (config.isPassthroughPlayerCounts() && pingInfo != null) {
            pong.playerCount(pingInfo.getPlayers().getOnline());
            pong.maximumPlayerCount(pingInfo.getPlayers().getMax());
        } else {
            pong.playerCount(this.geyser.getSessionManager().getSessions().size());
            pong.maximumPlayerCount(config.getMaxPlayers());
        }
        this.geyser.eventBus().fire(new GeyserBedrockPingEventImpl(pong, inetSocketAddress));
        pong.motd(pong.motd().replace(';', ':'));
        pong.subMotd(pong.subMotd().replace(';', ':'));
        if (pong.motd() == null || pong.motd().isBlank()) {
            pong.motd("Geyser");
        }
        if (pong.subMotd() == null || pong.subMotd().isBlank()) {
            pong.subMotd("Geyser");
        }
        if (ConnectionTestCommand.CONNECTION_TEST_MOTD != null) {
            pong.motd(ConnectionTestCommand.CONNECTION_TEST_MOTD);
            pong.subMotd("Geyser");
        }
        if ((motdArray = pong.motd().getBytes(StandardCharsets.UTF_8)).length + (subMotdLength = pong.subMotd().getBytes(StandardCharsets.UTF_8).length) > 338 - MINECRAFT_VERSION_BYTES_LENGTH) {
            if (subMotdLength > BRAND_BYTES_LENGTH) {
                pong.subMotd("Geyser");
                subMotdLength = BRAND_BYTES_LENGTH;
            }
            if (motdArray.length > 338 - MINECRAFT_VERSION_BYTES_LENGTH - subMotdLength) {
                byte[] newMotdArray = new byte[338 - MINECRAFT_VERSION_BYTES_LENGTH - subMotdLength];
                System.arraycopy(motdArray, 0, newMotdArray, 0, newMotdArray.length);
                pong.motd(new String(newMotdArray, StandardCharsets.UTF_8));
            }
        }
        if (pong.playerCount() >= pong.maximumPlayerCount()) {
            pong.maximumPlayerCount(pong.playerCount() + 1);
        }
        return pong;
    }

    private static Throwable throwableOrCaught(Supplier<Throwable> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    private static Transport compatibleTransport() {
        TransportHelper.TransportMethod transportMethod = TransportHelper.determineTransportMethod();
        if (transportMethod == TransportHelper.TransportMethod.EPOLL) {
            return new Transport(EpollDatagramChannel.class, EpollEventLoopGroup::new);
        }
        if (transportMethod == TransportHelper.TransportMethod.KQUEUE) {
            return new Transport(KQueueDatagramChannel.class, KQueueEventLoopGroup::new);
        }
        return new Transport(NioDatagramChannel.class, NioEventLoopGroup::new);
    }

    public ExpiringMap<InetSocketAddress, InetSocketAddress> getProxiedAddresses() {
        return this.proxiedAddresses;
    }

    private record Transport(Class<? extends DatagramChannel> datagramChannel, IntFunction<EventLoopGroup> eventLoopGroupFactory) {
    }
}

