/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.skin.SkinProvider;
import org.geysermc.geyser.util.FileUtils;

public class SkullResourcePackManager {
    private static final long RESOURCE_PACK_VERSION = 8L;
    private static final Path SKULL_SKIN_CACHE_PATH = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("player_skulls");
    public static final Map<String, Path> SKULL_SKINS = new Object2ObjectOpenHashMap<String, Path>();

    public static @Nullable Path createResourcePack() {
        Path path;
        Path cachePath = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache");
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().severe("Unable to create directories for player skull resource pack!", e);
            return null;
        }
        SkullResourcePackManager.cleanSkullSkinCache();
        Path packPath = cachePath.resolve("player_skulls.mcpack");
        File packFile = packPath.toFile();
        if (((Map)BlockRegistries.CUSTOM_SKULLS.get()).isEmpty() || !GeyserImpl.getInstance().getConfig().isAddNonBedrockItems()) {
            packFile.delete();
            return null;
        }
        if (packFile.exists() && SkullResourcePackManager.canReusePack(packFile)) {
            GeyserImpl.getInstance().getLogger().info("Reusing cached player skull resource pack.");
            return packPath;
        }
        GeyserImpl.getInstance().getLogger().info("Creating skull resource pack.");
        packFile.delete();
        ZipOutputStream zipOS = new ZipOutputStream(Files.newOutputStream(packPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        try {
            SkullResourcePackManager.addBaseResources(zipOS);
            SkullResourcePackManager.addSkinTextures(zipOS);
            SkullResourcePackManager.addAttachables(zipOS);
            GeyserImpl.getInstance().getLogger().info("Finished creating skull resource pack.");
            path = packPath;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipOS.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().severe("Unable to create player skull resource pack!", e);
                GeyserImpl.getInstance().getLogger().severe("Bedrock players will see dirt blocks instead of custom skull blocks.");
                packFile.delete();
                return null;
            }
        }
        zipOS.close();
        return path;
    }

    public static void cacheSkullSkin(String skinHash) throws IOException {
        String skinUrl = "https://textures.minecraft.net/texture/" + skinHash;
        Path skinPath = SKULL_SKINS.get(skinHash);
        if (skinPath != null) {
            return;
        }
        Files.createDirectories(SKULL_SKIN_CACHE_PATH, new FileAttribute[0]);
        skinPath = SKULL_SKIN_CACHE_PATH.resolve(skinHash + ".png");
        if (Files.exists(skinPath, new LinkOption[0])) {
            SKULL_SKINS.put(skinHash, skinPath);
            return;
        }
        BufferedImage image = SkinProvider.requestImage(skinUrl, null);
        BufferedImage skullTexture = new BufferedImage(48, 16, image.getType());
        Graphics2D g = skullTexture.createGraphics();
        g.drawImage(image, 0, 0, 32, 8, 0, 8, 32, 16, null);
        g.drawImage(image, 0, 8, 32, 16, 32, 8, 64, 16, null);
        g.drawImage(image, 32, 0, 48, 8, 8, 0, 24, 8, null);
        g.drawImage(image, 32, 8, 48, 16, 40, 0, 56, 8, null);
        g.dispose();
        image.flush();
        ImageIO.write((RenderedImage)skullTexture, "png", skinPath.toFile());
        SKULL_SKINS.put(skinHash, skinPath);
        GeyserImpl.getInstance().getLogger().debug("Cached player skull to " + skinPath + " for " + skinHash);
    }

    public static void cleanSkullSkinCache() {
        block11: {
            if (!Files.exists(SKULL_SKIN_CACHE_PATH, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> stream = Files.list(SKULL_SKIN_CACHE_PATH);){
                int removeCount = 0;
                for (Path path : stream.toList()) {
                    String skinHash = path.getFileName().toString();
                    if (SKULL_SKINS.containsKey(skinHash = skinHash.substring(0, skinHash.length() - ".png".length())) || !path.toFile().delete()) continue;
                    ++removeCount;
                }
                if (removeCount != 0) {
                    GeyserImpl.getInstance().getLogger().debug("Removed " + removeCount + " unnecessary skull skins.");
                }
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().debug("Unable to clean up skull skin cache.");
                if (!GeyserImpl.getInstance().getConfig().isDebugMode()) break block11;
                e.printStackTrace();
            }
        }
    }

    private static void addBaseResources(ZipOutputStream zipOS) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("bedrock/skull_resource_pack_files.txt")));){
            List<String> lines = reader.lines().toList();
            for (String path : lines) {
                ZipEntry entry = new ZipEntry(path);
                zipOS.putNextEntry(entry);
                String resourcePath = "bedrock/" + path;
                switch (path) {
                    case "skull_resource_pack/manifest.json": {
                        SkullResourcePackManager.fillTemplate(zipOS, resourcePath, SkullResourcePackManager::fillManifestJson);
                        break;
                    }
                    case "skull_resource_pack/textures/terrain_texture.json": {
                        SkullResourcePackManager.fillTemplate(zipOS, resourcePath, SkullResourcePackManager::fillTerrainTextureJson);
                        break;
                    }
                    default: {
                        zipOS.write(FileUtils.readAllBytes(resourcePath));
                    }
                }
                zipOS.closeEntry();
            }
            SkullResourcePackManager.addFloorGeometries(zipOS);
            ZipEntry entry = new ZipEntry("skull_resource_pack/pack_icon.png");
            zipOS.putNextEntry(entry);
            zipOS.write(FileUtils.readAllBytes("icon.png"));
            zipOS.closeEntry();
        }
    }

    private static void addFloorGeometries(ZipOutputStream zipOS) throws IOException {
        String template = FileUtils.readToString("bedrock/skull_resource_pack/models/blocks/player_skull_floor.geo.json");
        String[] quadrants = new String[]{"a", "b", "c", "d"};
        for (int i = 0; i < quadrants.length; ++i) {
            String quadrant = quadrants[i];
            float yRotation = (float)i * 22.5f;
            String contents = template.replace("${quadrant}", quadrant).replace("${y_rotation}", String.valueOf(yRotation));
            ZipEntry entry = new ZipEntry("skull_resource_pack/models/blocks/player_skull_floor_" + quadrant + ".geo.json");
            zipOS.putNextEntry(entry);
            zipOS.write(contents.getBytes(StandardCharsets.UTF_8));
            zipOS.closeEntry();
        }
    }

    private static void addAttachables(ZipOutputStream zipOS) throws IOException {
        String template = FileUtils.readToString("bedrock/skull_resource_pack/attachables/template_attachable.json");
        for (CustomSkull skull : ((Map)BlockRegistries.CUSTOM_SKULLS.get()).values()) {
            ZipEntry entry = new ZipEntry("skull_resource_pack/attachables/" + SkullResourcePackManager.truncateHash(skull.getSkinHash()) + ".json");
            zipOS.putNextEntry(entry);
            zipOS.write(SkullResourcePackManager.fillAttachableJson(template, skull).getBytes(StandardCharsets.UTF_8));
            zipOS.closeEntry();
        }
    }

    private static void addSkinTextures(ZipOutputStream zipOS) throws IOException {
        for (Path skinPath : SKULL_SKINS.values()) {
            ZipEntry entry = new ZipEntry("skull_resource_pack/textures/blocks/" + SkullResourcePackManager.truncateHash(skinPath.getFileName().toString()) + ".png");
            zipOS.putNextEntry(entry);
            try (InputStream stream = Files.newInputStream(skinPath, new OpenOption[0]);){
                stream.transferTo(zipOS);
            }
            zipOS.closeEntry();
        }
    }

    private static void fillTemplate(ZipOutputStream zipOS, String path, UnaryOperator<String> filler) throws IOException {
        String template = FileUtils.readToString(path);
        String result = (String)filler.apply(template);
        zipOS.write(result.getBytes(StandardCharsets.UTF_8));
    }

    private static String fillAttachableJson(String template, CustomSkull skull) {
        return template.replace("${identifier}", skull.getCustomBlockData().identifier()).replace("${texture}", SkullResourcePackManager.truncateHash(skull.getSkinHash()));
    }

    private static String fillManifestJson(String template) {
        Pair<UUID, UUID> uuids = SkullResourcePackManager.generatePackUUIDs();
        return template.replace("${uuid1}", uuids.first().toString()).replace("${uuid2}", uuids.second().toString());
    }

    private static String fillTerrainTextureJson(String template) {
        StringBuilder textures = new StringBuilder();
        for (String skinHash : SKULL_SKINS.keySet()) {
            String texture = String.format("\"geyser.%s_player_skin\":{\"textures\":\"textures/blocks/%s\"},\n", skinHash, SkullResourcePackManager.truncateHash(skinHash));
            textures.append(texture);
        }
        if (textures.length() != 0) {
            textures.delete(textures.length() - 2, textures.length());
        }
        return template.replace("${texture_data}", textures);
    }

    private static Pair<UUID, UUID> generatePackUUIDs() {
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (int i = 0; i < 8; ++i) {
                md.update((byte)(8L >> i * 8 & 0xFFL));
            }
            SKULL_SKINS.keySet().stream().sorted().map(hash -> hash.getBytes(StandardCharsets.UTF_8)).forEach(md::update);
            ByteBuffer skinHashes = ByteBuffer.wrap(md.digest());
            uuid1 = new UUID(skinHashes.getLong(), skinHashes.getLong());
            uuid2 = new UUID(skinHashes.getLong(), skinHashes.getLong());
        }
        catch (NoSuchAlgorithmException e) {
            GeyserImpl.getInstance().getLogger().severe("Unable to get SHA-256 Message Digest instance! Bedrock players will have to re-downloaded the player skull resource pack after each server restart.", e);
        }
        return Pair.of(uuid1, uuid2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canReusePack(File packFile) {
        Pair<UUID, UUID> uuids = SkullResourcePackManager.generatePackUUIDs();
        try (ZipFile zipFile = new ZipFile(packFile);){
            Optional<ZipEntry> manifestEntry = zipFile.stream().filter(entry -> entry.getName().contains("manifest.json")).findFirst();
            if (!manifestEntry.isPresent()) return false;
            GeyserResourcePackManifest manifest = FileUtils.loadJson(zipFile.getInputStream(manifestEntry.get()), GeyserResourcePackManifest.class);
            if (!uuids.first().equals(manifest.header().uuid())) {
                boolean bl = false;
                return bl;
            }
            Optional<UUID> resourceUUID = manifest.modules().stream().filter(module -> "resources".equals(module.type())).findFirst().map(ResourcePackManifest.Module::uuid);
            boolean bl = resourceUUID.isPresent() && uuids.second().equals(resourceUUID.get());
            return bl;
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().debug("Cached player skull resource pack was invalid! The pack will be recreated.");
        }
        return false;
    }

    private static String truncateHash(String hash) {
        return hash.substring(0, Math.min(hash.length(), 32));
    }
}

