/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.bukkit.Bukkit;
import org.geysermc.geyser.GeyserImpl;

public class GeyserSpigotCompressionDisabler
extends ChannelOutboundHandlerAdapter {
    static final boolean ENABLED;
    private static final Class<?> COMPRESSION_PACKET_CLASS;
    private static final Class<?> LOGIN_SUCCESS_PACKET_CLASS;
    private static final boolean PROTOCOL_SUPPORT_INSTALLED;

    public GeyserSpigotCompressionDisabler() {
        if (!ENABLED) {
            throw new RuntimeException("Geyser compression disabler cannot be initialized in its current state!");
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Class<?> msgClass = msg.getClass();
        if (!COMPRESSION_PACKET_CLASS.isAssignableFrom(msgClass)) {
            if (LOGIN_SUCCESS_PACKET_CLASS.isAssignableFrom(msgClass)) {
                if (PROTOCOL_SUPPORT_INSTALLED) {
                    if (ctx.pipeline().get("compress") != null) {
                        ctx.pipeline().remove("compress");
                    }
                    if (ctx.pipeline().get("decompress") != null) {
                        ctx.pipeline().remove("decompress");
                    }
                }
                ctx.channel().pipeline().remove((ChannelHandler)this);
            }
            super.write(ctx, msg, promise);
        } else if (PROTOCOL_SUPPORT_INSTALLED) {
            promise.setSuccess();
        }
    }

    private static Class<?> findCompressionPacket() throws ClassNotFoundException {
        try {
            return Class.forName("net.minecraft.network.protocol.login.PacketLoginOutSetCompression");
        }
        catch (ClassNotFoundException e) {
            String prefix = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "net.minecraft.server");
            return Class.forName(prefix + ".PacketLoginOutSetCompression");
        }
    }

    private static Class<?> findLoginSuccessPacket() throws ClassNotFoundException {
        try {
            return Class.forName("net.minecraft.network.protocol.login.PacketLoginOutSuccess");
        }
        catch (ClassNotFoundException e) {
            String prefix = Bukkit.getServer().getClass().getPackage().getName().replace("org.bukkit.craftbukkit", "net.minecraft.server");
            return Class.forName(prefix + ".PacketLoginOutSuccess");
        }
    }

    static {
        PROTOCOL_SUPPORT_INSTALLED = Bukkit.getPluginManager().getPlugin("ProtocolSupport") != null;
        Class<?> compressionPacketClass = null;
        Class<?> loginSuccessPacketClass = null;
        boolean enabled = false;
        try {
            compressionPacketClass = GeyserSpigotCompressionDisabler.findCompressionPacket();
            loginSuccessPacketClass = GeyserSpigotCompressionDisabler.findLoginSuccessPacket();
            enabled = true;
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not initialize compression disabler!", e);
        }
        COMPRESSION_PACKET_CLASS = compressionPacketClass;
        LOGIN_SUCCESS_PACKET_CLASS = loginSuccessPacketClass;
        ENABLED = enabled;
    }
}

