/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.world;

import com.github.steveice10.mc.protocol.data.game.level.block.value.PistonValueType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotWorldManager;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.translator.level.block.entity.PistonBlockEntity;

public class GeyserPistonListener
implements Listener {
    private final GeyserImpl geyser;
    private final GeyserSpigotWorldManager worldManager;

    public GeyserPistonListener(GeyserImpl geyser, GeyserSpigotWorldManager worldManager) {
        this.geyser = geyser;
        this.worldManager = worldManager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        this.onPistonAction((BlockPistonEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        this.onPistonAction((BlockPistonEvent)event);
    }

    private void onPistonAction(BlockPistonEvent event) {
        if (event.isCancelled()) {
            return;
        }
        World world = event.getBlock().getWorld();
        boolean isExtend = event instanceof BlockPistonExtendEvent;
        Location location = event.getBlock().getLocation();
        Vector3i position = this.getVector(location);
        PistonValueType type = isExtend ? PistonValueType.PUSHING : PistonValueType.PULLING;
        boolean sticky = event.isSticky();
        Object2IntArrayMap<Vector3i> attachedBlocks = new Object2IntArrayMap<Vector3i>();
        boolean blocksFilled = false;
        for (Map.Entry<UUID, GeyserSession> entry : this.geyser.getSessionManager().getSessions().entrySet()) {
            int dZ;
            Player player = Bukkit.getPlayer((UUID)entry.getKey());
            if (player == null || !player.getWorld().equals(world)) continue;
            GeyserSession session = entry.getValue();
            int dX = Math.abs(location.getBlockX() - player.getLocation().getBlockX()) >> 4;
            if (dX * dX + (dZ = Math.abs(location.getBlockZ() - player.getLocation().getBlockZ()) >> 4) * dZ > session.getServerRenderDistance() * session.getServerRenderDistance()) continue;
            if (!blocksFilled) {
                List blocks = isExtend ? ((BlockPistonExtendEvent)event).getBlocks() : ((BlockPistonRetractEvent)event).getBlocks();
                for (Block block : blocks) {
                    Location attachedLocation = block.getLocation();
                    int blockId = this.worldManager.getBlockNetworkId(block);
                    if (!BlockStateValues.canPistonMoveBlock(blockId, isExtend)) continue;
                    attachedBlocks.put(this.getVector(attachedLocation), blockId);
                }
                blocksFilled = true;
            }
            int pistonBlockId = this.worldManager.getBlockNetworkId(event.getBlock());
            Direction orientation = BlockStateValues.getPistonOrientation(pistonBlockId);
            session.executeInEventLoop(() -> {
                PistonCache pistonCache = session.getPistonCache();
                PistonBlockEntity blockEntity = pistonCache.getPistons().computeIfAbsent(position, pos -> new PistonBlockEntity(session, position, orientation, sticky, !isExtend));
                blockEntity.setAction(type, attachedBlocks);
            });
        }
    }

    private Vector3i getVector(Location location) {
        return Vector3i.from(location.getX(), location.getY(), location.getZ());
    }
}

