/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import java.io.InputStream;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.Enchantment;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.type.EnchantmentData;

public class EnchantmentRegistryLoader
implements RegistryLoader<String, Map<Enchantment.JavaEnchantment, EnchantmentData>> {
    @Override
    public Map<Enchantment.JavaEnchantment, EnchantmentData> load(String input) {
        JsonNode enchantmentsNode;
        try (InputStream enchantmentsStream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);){
            enchantmentsNode = GeyserImpl.JSON_MAPPER.readTree(enchantmentsStream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load enchantment data", e);
        }
        EnumMap<Enchantment.JavaEnchantment, EnchantmentData> enchantments = new EnumMap<Enchantment.JavaEnchantment, EnchantmentData>(Enchantment.JavaEnchantment.class);
        Iterator<Map.Entry<String, JsonNode>> it = enchantmentsNode.fields();
        while (it.hasNext()) {
            Object incompatibleNode2;
            Map.Entry<String, JsonNode> entry = it.next();
            Enchantment.JavaEnchantment key = Enchantment.JavaEnchantment.getByJavaIdentifier(entry.getKey());
            JsonNode node = entry.getValue();
            int rarityMultiplier = switch (node.get("rarity").textValue()) {
                case "common" -> 1;
                case "uncommon" -> 2;
                case "rare" -> 4;
                case "very_rare" -> 8;
                default -> throw new IllegalStateException("Unexpected value: " + node.get("rarity").textValue());
            };
            int maxLevel = node.get("max_level").asInt();
            EnumSet<Enchantment.JavaEnchantment> incompatibleEnchantments = EnumSet.noneOf(Enchantment.JavaEnchantment.class);
            JsonNode incompatibleEnchantmentsNode = node.get("incompatible_enchantments");
            if (incompatibleEnchantmentsNode != null) {
                for (Object incompatibleNode2 : incompatibleEnchantmentsNode) {
                    incompatibleEnchantments.add(Enchantment.JavaEnchantment.getByJavaIdentifier(((JsonNode)incompatibleNode2).textValue()));
                }
            }
            IntOpenHashSet validItems = new IntOpenHashSet();
            incompatibleNode2 = node.get("valid_items").iterator();
            while (incompatibleNode2.hasNext()) {
                JsonNode itemNode = (JsonNode)incompatibleNode2.next();
                String javaIdentifier = itemNode.textValue();
                Item item = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(javaIdentifier);
                if (item != null) {
                    validItems.add(item.javaId());
                    continue;
                }
                throw new NullPointerException("No item entry exists for java identifier: " + javaIdentifier);
            }
            EnchantmentData enchantmentData = new EnchantmentData(rarityMultiplier, maxLevel, incompatibleEnchantments, validItems);
            enchantments.put(key, enchantmentData);
        }
        return enchantments;
    }
}

