/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import java.util.Map;
import java.util.WeakHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class LodestoneCache {
    private final Map<GeyserItemStack, LodestonePos> activeLodestones = new WeakHashMap<GeyserItemStack, LodestonePos>();
    private final Int2ObjectMap<LodestonePos> lodestones = new Int2ObjectOpenHashMap<LodestonePos>();
    private int id = 1;

    public void cacheInventoryItem(GeyserItemStack itemStack) {
        CompoundTag tag = itemStack.getNbt();
        if (tag == null) {
            return;
        }
        CompoundTag lodestonePos = (CompoundTag)tag.get("LodestonePos");
        if (lodestonePos == null) {
            return;
        }
        int x = ((IntTag)lodestonePos.get("X")).getValue();
        int y = ((IntTag)lodestonePos.get("Y")).getValue();
        int z = ((IntTag)lodestonePos.get("Z")).getValue();
        String dim = ((StringTag)tag.get("LodestoneDimension")).getValue();
        for (LodestonePos pos : this.activeLodestones.values()) {
            if (!pos.equals(x, y, z, dim)) continue;
            this.activeLodestones.put(itemStack, pos);
            return;
        }
        for (LodestonePos pos : this.lodestones.values()) {
            if (!pos.equals(x, y, z, dim)) continue;
            this.activeLodestones.put(itemStack, pos);
            return;
        }
        this.activeLodestones.put(itemStack, new LodestonePos(this.id++, x, y, z, dim));
    }

    public int store(CompoundTag tag) {
        CompoundTag lodestonePos = (CompoundTag)tag.get("LodestonePos");
        if (lodestonePos == null) {
            return 0;
        }
        int x = ((IntTag)lodestonePos.get("X")).getValue();
        int y = ((IntTag)lodestonePos.get("Y")).getValue();
        int z = ((IntTag)lodestonePos.get("Z")).getValue();
        String dim = ((StringTag)tag.get("LodestoneDimension")).getValue();
        for (LodestonePos lodestonePos2 : this.activeLodestones.values()) {
            if (!lodestonePos2.equals(x, y, z, dim)) continue;
            return lodestonePos2.id;
        }
        for (Int2ObjectMap.Entry entry : this.lodestones.int2ObjectEntrySet()) {
            if (!((LodestonePos)entry.getValue()).equals(x, y, z, dim)) continue;
            return entry.getIntKey();
        }
        this.lodestones.put(this.id, new LodestonePos(this.id, x, y, z, dim));
        return this.id++;
    }

    public @Nullable LodestonePos getPos(int id) {
        LodestonePos pos = (LodestonePos)this.lodestones.remove(id);
        if (pos != null) {
            return pos;
        }
        for (LodestonePos activePos : this.activeLodestones.values()) {
            if (activePos.id != id) continue;
            return activePos;
        }
        return null;
    }

    public void clear() {
        this.activeLodestones.clear();
        this.lodestones.clear();
    }

    public record LodestonePos(int id, int x, int y, int z, String dimension) {
        boolean equals(int x, int y, int z, String dimension) {
            return this.x == x && this.y == y && this.z == z && this.dimension.equals(dimension);
        }
    }
}

