/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="^dirt_path$", passDefaultBoxes=true)
public class DirtPathCollision
extends BlockCollision {
    public DirtPathCollision(String params, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
    }

    @Override
    public void beforeCorrectPosition(int x, int y, int z, BoundingBox playerCollision) {
        double blockMaxY = y + 1;
        double playerMinY = playerCollision.getMiddleY() - playerCollision.getSizeY() / 2.0;
        if (Math.abs(blockMaxY - playerMinY) <= 1.0E-5) {
            playerCollision.translate(0.0, -0.0625, 0.0);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirtPathCollision)) {
            return false;
        }
        DirtPathCollision other = (DirtPathCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DirtPathCollision;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

