/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import com.github.steveice10.mc.protocol.data.game.level.block.BlockEntityType;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.StringTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;

@BlockEntity(type={BlockEntityType.MOB_SPAWNER})
public class SpawnerBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, CompoundTag tag, int blockState) {
        CompoundTag entityTag;
        CompoundTag spawnData = (CompoundTag)tag.get("SpawnData");
        if (spawnData != null && (entityTag = (CompoundTag)spawnData.get("entity")).isEmpty()) {
            Vector3i position = Vector3i.from(x, y, z);
            UpdateBlockPacket emptyBlockPacket = new UpdateBlockPacket();
            emptyBlockPacket.setDataLayer(0);
            emptyBlockPacket.setBlockPosition(position);
            emptyBlockPacket.setDefinition(session.getBlockMappings().getBedrockAir());
            session.sendUpstreamPacket(emptyBlockPacket);
            UpdateBlockPacket spawnerBlockPacket = new UpdateBlockPacket();
            spawnerBlockPacket.setDataLayer(0);
            spawnerBlockPacket.setBlockPosition(position);
            spawnerBlockPacket.setDefinition(session.getBlockMappings().getMobSpawnerBlock());
            session.sendUpstreamPacket(spawnerBlockPacket);
        }
        return super.getBlockEntityTag(session, type, x, y, z, tag, blockState);
    }

    @Override
    public void translateTag(NbtMapBuilder builder, CompoundTag tag, int blockState) {
        Object current = tag.get("MaxNearbyEntities");
        if (current != null) {
            builder.put("MaxNearbyEntities", ((Tag)current).getValue());
        }
        if ((current = tag.get("RequiredPlayerRange")) != null) {
            builder.put("RequiredPlayerRange", ((Tag)current).getValue());
        }
        if ((current = tag.get("SpawnCount")) != null) {
            builder.put("SpawnCount", ((Tag)current).getValue());
        }
        if ((current = tag.get("MaxSpawnDelay")) != null) {
            builder.put("MaxSpawnDelay", ((Tag)current).getValue());
        }
        if ((current = tag.get("Delay")) != null) {
            builder.put("Delay", ((Tag)current).getValue());
        }
        if ((current = tag.get("SpawnRange")) != null) {
            builder.put("SpawnRange", ((Tag)current).getValue());
        }
        if ((current = tag.get("MinSpawnDelay")) != null) {
            builder.put("MinSpawnDelay", ((Tag)current).getValue());
        }
        SpawnerBlockEntityTranslator.translateSpawnData(builder, (CompoundTag)tag.get("SpawnData"));
        builder.put("isMovable", (Object)1);
    }

    static void translateSpawnData(@NonNull NbtMapBuilder builder, @Nullable CompoundTag spawnData) {
        if (spawnData == null) {
            return;
        }
        CompoundTag entityTag = (CompoundTag)spawnData.get("entity");
        Object t = entityTag.get("id");
        if (t instanceof StringTag) {
            StringTag idTag = (StringTag)t;
            String entityId = idTag.getValue();
            builder.put("EntityIdentifier", (Object)entityId);
            EntityDefinition definition = (EntityDefinition)Registries.JAVA_ENTITY_IDENTIFIERS.get(entityId);
            if (definition != null) {
                builder.put("DisplayEntityWidth", (Object)Float.valueOf(definition.width()));
                builder.put("DisplayEntityHeight", (Object)Float.valueOf(definition.height()));
                builder.put("DisplayEntityScale", (Object)Float.valueOf(1.0f));
            }
        }
    }
}

