/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.packet.ServerSettingsRequestPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerSettingsResponsePacket;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.impl.FormDefinitions;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.SettingsUtils;

@Translator(packet=ServerSettingsRequestPacket.class)
public class BedrockServerSettingsRequestTranslator
extends PacketTranslator<ServerSettingsRequestPacket> {
    private final FormDefinitions formDefinitions = FormDefinitions.instance();

    @Override
    public void translate(GeyserSession session, ServerSettingsRequestPacket packet) {
        CustomForm form = SettingsUtils.buildForm(session);
        int formId = session.getFormCache().addForm(form);
        String jsonData = this.formDefinitions.codecFor(form).jsonData((CustomForm)form);
        session.scheduleInEventLoop(() -> {
            ServerSettingsResponsePacket serverSettingsResponsePacket = new ServerSettingsResponsePacket();
            serverSettingsResponsePacket.setFormData(jsonData);
            serverSettingsResponsePacket.setFormId(formId);
            session.sendUpstreamPacket(serverSettingsResponsePacket);
        }, 1L, TimeUnit.SECONDS);
    }
}

