/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import com.github.steveice10.mc.protocol.packet.ingame.clientbound.ClientboundBossEventPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BossBar;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=ClientboundBossEventPacket.class)
public class JavaBossEventTranslator
extends PacketTranslator<ClientboundBossEventPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundBossEventPacket packet) {
        BossBar bossBar = session.getEntityCache().getBossBar(packet.getUuid());
        switch (packet.getAction()) {
            case ADD: {
                long entityId = session.getEntityCache().getNextEntityId().incrementAndGet();
                bossBar = new BossBar(session, entityId, packet.getTitle(), packet.getHealth(), packet.getColor().ordinal(), 1, 0);
                session.getEntityCache().addBossBar(packet.getUuid(), bossBar);
                break;
            }
            case UPDATE_TITLE: {
                if (bossBar == null) break;
                bossBar.updateTitle(packet.getTitle());
                break;
            }
            case UPDATE_HEALTH: {
                if (bossBar == null) break;
                bossBar.updateHealth(packet.getHealth());
                break;
            }
            case REMOVE: {
                session.getEntityCache().removeBossBar(packet.getUuid());
                break;
            }
            case UPDATE_STYLE: {
                if (bossBar == null) break;
                bossBar.updateColor(packet.getColor().ordinal());
                break;
            }
        }
    }
}

