/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import com.github.steveice10.mc.protocol.data.game.entity.player.PositionElement;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player.ClientboundPlayerPositionPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.level.ServerboundAcceptTeleportationPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosRotPacket;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.RespawnPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.ChunkUtils;

@Translator(packet=ClientboundPlayerPositionPacket.class)
public class JavaPlayerPositionTranslator
extends PacketTranslator<ClientboundPlayerPositionPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerPositionPacket packet) {
        if (!session.isLoggedIn()) {
            return;
        }
        SessionPlayerEntity entity = session.getPlayerEntity();
        if (!session.isSpawned()) {
            Vector3f pos = Vector3f.from(packet.getX(), packet.getY(), packet.getZ());
            entity.setPosition(pos);
            entity.setYaw(packet.getYaw());
            entity.setPitch(packet.getPitch());
            entity.setHeadYaw(packet.getYaw());
            RespawnPacket respawnPacket = new RespawnPacket();
            respawnPacket.setRuntimeEntityId(0L);
            respawnPacket.setPosition(entity.getPosition());
            respawnPacket.setState(RespawnPacket.State.SERVER_READY);
            session.sendUpstreamPacket(respawnPacket);
            entity.updateBedrockMetadata();
            MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
            movePlayerPacket.setRuntimeEntityId(entity.getGeyserId());
            movePlayerPacket.setPosition(entity.getPosition());
            movePlayerPacket.setRotation(entity.getBedrockRotation());
            movePlayerPacket.setMode(MovePlayerPacket.Mode.RESPAWN);
            session.sendUpstreamPacket(movePlayerPacket);
            session.setSpawned(true);
            session.setUnconfirmedTeleport(new TeleportCache(packet.getX(), packet.getY(), packet.getZ(), packet.getPitch(), packet.getYaw(), packet.getTeleportId()));
            this.acceptTeleport(session, packet.getX(), packet.getY(), packet.getZ(), packet.getYaw(), packet.getPitch(), packet.getTeleportId());
            if (session.getServerRenderDistance() > 32 && !session.isEmulatePost1_13Logic()) {
                ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
                chunkRadiusUpdatedPacket.setRadius(session.getServerRenderDistance());
                session.sendUpstreamPacket(chunkRadiusUpdatedPacket);
                session.setLastChunkPosition(null);
            }
            ChunkUtils.updateChunkPosition(session, pos.toInt());
            if (session.getGeyser().getConfig().isDebugMode()) {
                session.getGeyser().getLogger().debug("Spawned player at " + packet.getX() + " " + packet.getY() + " " + packet.getZ());
            }
            return;
        }
        double newX = packet.getX() + (double)(packet.getRelative().contains((Object)PositionElement.X) ? entity.getPosition().getX() : 0.0f);
        double newY = packet.getY() + (double)(packet.getRelative().contains((Object)PositionElement.Y) ? entity.getPosition().getY() - EntityDefinitions.PLAYER.offset() : 0.0f);
        double newZ = packet.getZ() + (double)(packet.getRelative().contains((Object)PositionElement.Z) ? entity.getPosition().getZ() : 0.0f);
        float newPitch = packet.getPitch() + (packet.getRelative().contains((Object)PositionElement.PITCH) ? entity.getPitch() : 0.0f);
        float newYaw = packet.getYaw() + (packet.getRelative().contains((Object)PositionElement.YAW) ? entity.getYaw() : 0.0f);
        int id = packet.getTeleportId();
        session.getGeyser().getLogger().debug("Teleport (" + id + ") from " + entity.getPosition().getX() + " " + (entity.getPosition().getY() - EntityDefinitions.PLAYER.offset()) + " " + entity.getPosition().getZ());
        Vector3f lastPlayerPosition = entity.getPosition().down(EntityDefinitions.PLAYER.offset());
        float lastPlayerPitch = entity.getPitch();
        Vector3f teleportDestination = Vector3f.from(newX, newY, newZ);
        entity.moveAbsolute(teleportDestination, newYaw, newPitch, true, true);
        session.getGeyser().getLogger().debug("to " + entity.getPosition().getX() + " " + (entity.getPosition().getY() - EntityDefinitions.PLAYER.offset()) + " " + entity.getPosition().getZ());
        if ((double)lastPlayerPosition.distanceSquared(teleportDestination) < 0.001 && Math.abs(newPitch - lastPlayerPitch) < 5.0f) {
            session.setUnconfirmedTeleport(null);
        } else {
            session.setUnconfirmedTeleport(new TeleportCache(newX, newY, newZ, newPitch, newYaw, id));
        }
        this.acceptTeleport(session, newX, newY, newZ, newYaw, newPitch, id);
    }

    private void acceptTeleport(GeyserSession session, double x, double y, double z, float yaw, float pitch, int id) {
        ServerboundAcceptTeleportationPacket teleportConfirmPacket = new ServerboundAcceptTeleportationPacket(id);
        session.sendDownstreamGamePacket(teleportConfirmPacket);
        ServerboundMovePlayerPosRotPacket positionPacket = new ServerboundMovePlayerPosRotPacket(false, x, y, z, yaw, pitch);
        session.sendDownstreamGamePacket(positionPacket);
    }
}

