/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import com.github.steveice10.mc.protocol.data.game.entity.metadata.ItemStack;
import com.github.steveice10.mc.protocol.data.game.recipe.Ingredient;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundContainerSetSlotPacket;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.recipe.ShapedRecipeData;
import org.cloudburstmc.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.PlayerInventoryTranslator;
import org.geysermc.geyser.translator.inventory.item.ItemTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundContainerSetSlotPacket.class)
public class JavaContainerSetSlotTranslator
extends PacketTranslator<ClientboundContainerSetSlotPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundContainerSetSlotPacket packet) {
        if (packet.getContainerId() == 255) {
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItem());
            session.getPlayerInventory().setCursor(newItem, session);
            InventoryUtils.updateCursor(session);
            return;
        }
        Inventory inventory = InventoryUtils.getInventory(session, packet.getContainerId());
        if (inventory == null) {
            return;
        }
        InventoryTranslator translator = session.getInventoryTranslator();
        if (translator != null) {
            int slot;
            if (session.getCraftingGridFuture() != null) {
                session.getCraftingGridFuture().cancel(false);
            }
            if ((slot = packet.getSlot()) >= inventory.getSize()) {
                GeyserImpl geyser = session.getGeyser();
                geyser.getLogger().warning("ClientboundContainerSetSlotPacket sent to " + session.bedrockUsername() + " that exceeds inventory size!");
                if (geyser.getConfig().isDebugMode()) {
                    geyser.getLogger().debug(packet);
                    geyser.getLogger().debug(inventory);
                }
                return;
            }
            JavaContainerSetSlotTranslator.updateCraftingGrid(session, slot, packet.getItem(), inventory, translator);
            GeyserItemStack newItem = GeyserItemStack.from(packet.getItem());
            if (packet.getContainerId() == 0 && !(translator instanceof PlayerInventoryTranslator)) {
                session.getPlayerInventory().setItem(slot, newItem, session);
                InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR.updateSlot(session, session.getPlayerInventory(), slot);
            } else {
                inventory.setItem(slot, newItem, session);
                translator.updateSlot(session, inventory, slot);
            }
            int stateId = packet.getStateId();
            session.setEmulatePost1_16Logic(stateId > 0 || stateId != inventory.getStateId());
            inventory.setStateId(stateId);
        }
    }

    private static void updateCraftingGrid(GeyserSession session, int slot, ItemStack item, Inventory inventory, InventoryTranslator translator) {
        if (slot != 0) {
            return;
        }
        int gridSize = translator.getGridSize();
        if (gridSize == -1) {
            return;
        }
        if (InventoryUtils.isEmpty(item)) {
            return;
        }
        session.setCraftingGridFuture(session.scheduleInEventLoop(() -> {
            int offset = gridSize == 4 ? 28 : 32;
            int gridDimensions = gridSize == 4 ? 2 : 3;
            int firstRow = -1;
            int height = -1;
            int firstCol = -1;
            int width = -1;
            for (int row = 0; row < gridDimensions; ++row) {
                for (int col = 0; col < gridDimensions; ++col) {
                    if (inventory.getItem(col + row * gridDimensions + 1).isEmpty()) continue;
                    if (firstRow == -1) {
                        firstRow = row;
                        firstCol = col;
                    } else {
                        firstCol = Math.min(firstCol, col);
                    }
                    height = Math.max(height, row);
                    width = Math.max(width, col);
                }
            }
            if (firstRow == -1) {
                return;
            }
            if (InventoryUtils.getValidRecipe(session, item, inventory::getItem, gridDimensions, firstRow, height += -firstRow + 1, firstCol, width += -firstCol + 1) != null) {
                return;
            }
            UUID uuid = UUID.randomUUID();
            int newRecipeId = session.getLastRecipeNetId().incrementAndGet();
            ItemData[] ingredients = new ItemData[height * width];
            Ingredient[] javaIngredients = new Ingredient[height * width];
            int index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    GeyserItemStack geyserItemStack = inventory.getItem(col + row * gridDimensions + 1);
                    ingredients[index] = geyserItemStack.getItemData(session);
                    ItemStack[] itemStacks = new ItemStack[]{geyserItemStack.isEmpty() ? null : geyserItemStack.getItemStack(1)};
                    javaIngredients[index] = new Ingredient(itemStacks);
                    InventorySlotPacket slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ItemData.AIR);
                    session.sendUpstreamPacket(slotPacket);
                    ++index;
                }
            }
            session.getCraftingRecipes().put(newRecipeId, (GeyserRecipe)new GeyserShapedRecipe(width, height, javaIngredients, item));
            CraftingDataPacket craftPacket = new CraftingDataPacket();
            craftPacket.getCraftingData().add(ShapedRecipeData.shaped(uuid.toString(), width, height, Arrays.stream(ingredients).map(ItemDescriptorWithCount::fromItem).toList(), Collections.singletonList(ItemTranslator.translateToBedrock(session, item)), uuid, "crafting_table", 0, newRecipeId));
            craftPacket.setCleanRecipes(false);
            session.sendUpstreamPacket(craftPacket);
            index = 0;
            for (int row = firstRow; row < height + firstRow; ++row) {
                for (int col = firstCol; col < width + firstCol; ++col) {
                    InventorySlotPacket slotPacket = new InventorySlotPacket();
                    slotPacket.setContainerId(124);
                    slotPacket.setSlot(col + row * gridDimensions + offset);
                    slotPacket.setItem(ingredients[index]);
                    session.sendUpstreamPacket(slotPacket);
                    ++index;
                }
            }
        }, 150L, TimeUnit.MILLISECONDS));
    }
}

