/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.inventory;

import com.github.steveice10.mc.protocol.data.game.inventory.ContainerType;
import com.github.steveice10.mc.protocol.packet.ingame.clientbound.inventory.ClientboundOpenScreenPacket;
import com.github.steveice10.mc.protocol.packet.ingame.serverbound.inventory.ServerboundContainerClosePacket;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.inventory.OldSmithingTableTranslator;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=ClientboundOpenScreenPacket.class)
public class JavaOpenScreenTranslator
extends PacketTranslator<ClientboundOpenScreenPacket> {
    private static final Component SMITHING_TABLE_COMPONENT = Component.translatable("container.upgrade");

    @Override
    public void translate(GeyserSession session, ClientboundOpenScreenPacket packet) {
        InventoryTranslator newTranslator;
        if (packet.getContainerId() == 0) {
            return;
        }
        Inventory openInventory = session.getOpenInventory();
        if (session.isOldSmithingTable() && packet.getType() == ContainerType.FURNACE && packet.getTitle().equals(SMITHING_TABLE_COMPONENT)) {
            newTranslator = OldSmithingTableTranslator.INSTANCE;
        } else if (packet.getType() == ContainerType.CRAFTER_3x3 && GameProtocol.isPre1_20_50(session)) {
            newTranslator = null;
            session.sendMessage("\u00a7cUpdate your Bedrock Edition client to 1.20.50 or above to gain access to the Crafter.");
        } else {
            newTranslator = InventoryTranslator.inventoryTranslator(packet.getType());
        }
        if (newTranslator == null) {
            if (openInventory != null) {
                InventoryUtils.closeInventory(session, openInventory.getJavaId(), true);
            }
            ServerboundContainerClosePacket closeWindowPacket = new ServerboundContainerClosePacket(packet.getContainerId());
            session.sendDownstreamGamePacket(closeWindowPacket);
            return;
        }
        String name = MessageTranslator.convertMessage(packet.getTitle(), session.locale());
        Inventory newInventory = newTranslator.createInventory(name, packet.getContainerId(), packet.getType(), session.getPlayerInventory());
        if (!(openInventory == null || openInventory.getContainerType() == packet.getType() && openInventory.getTitle().equals(name))) {
            InventoryUtils.closeInventory(session, openInventory.getJavaId(), openInventory.getJavaId() != packet.getContainerId());
        }
        session.setInventoryTranslator(newTranslator);
        InventoryUtils.openInventory(session, newInventory);
    }
}

