/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.level.block.BlockStateValues;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.BlockMapping;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.ItemUtils;

public final class BlockUtils {
    private static boolean correctTool(GeyserSession session, BlockMapping blockMapping, String itemToolType) {
        switch (itemToolType) {
            case "axe": {
                return session.getTagCache().isAxeEffective(blockMapping);
            }
            case "hoe": {
                return session.getTagCache().isHoeEffective(blockMapping);
            }
            case "pickaxe": {
                return session.getTagCache().isPickaxeEffective(blockMapping);
            }
            case "shears": {
                return session.getTagCache().isShearsEffective(blockMapping);
            }
            case "shovel": {
                return session.getTagCache().isShovelEffective(blockMapping);
            }
            case "sword": {
                return blockMapping.getJavaBlockId() == BlockStateValues.JAVA_COBWEB_ID;
            }
        }
        session.getGeyser().getLogger().warning("Unknown tool type: " + itemToolType);
        return false;
    }

    private static double toolBreakTimeBonus(String toolType, String toolTier, boolean isShearsEffective) {
        if (toolType.equals("shears")) {
            return isShearsEffective ? 5.0 : 15.0;
        }
        if (toolType.equals("")) {
            return 1.0;
        }
        return switch (toolTier) {
            case "wooden" -> 2.0;
            case "stone" -> 4.0;
            case "iron" -> 6.0;
            case "diamond" -> 8.0;
            case "netherite" -> 9.0;
            case "golden" -> 12.0;
            default -> 1.0;
        };
    }

    private static boolean canToolTierBreakBlock(GeyserSession session, BlockMapping blockMapping, String toolTier) {
        if (toolTier.equals("netherite") || toolTier.equals("diamond")) {
            return true;
        }
        switch (toolTier) {
            default: {
                if (session.getTagCache().requiresStoneTool(blockMapping)) {
                    return false;
                }
            }
            case "stone": {
                if (!session.getTagCache().requiresIronTool(blockMapping)) break;
                return false;
            }
            case "iron": 
        }
        return !session.getTagCache().requiresDiamondTool(blockMapping);
    }

    private static double calculateBreakTime(double blockHardness, String toolTier, boolean canHarvestWithHand, boolean correctTool, boolean canTierMineBlock, String toolType, boolean isShearsEffective, int toolEfficiencyLevel, int hasteLevel, int miningFatigueLevel, boolean insideOfWaterWithoutAquaAffinity, boolean onGround) {
        double baseTime = (correctTool && canTierMineBlock || canHarvestWithHand ? 1.5 : 5.0) * blockHardness;
        double speed = 1.0 / baseTime;
        if (correctTool) {
            speed *= BlockUtils.toolBreakTimeBonus(toolType, toolTier, isShearsEffective);
            speed += toolEfficiencyLevel == 0 ? 0.0 : (double)(toolEfficiencyLevel * toolEfficiencyLevel + 1);
        }
        speed *= 1.0 + 0.2 * (double)hasteLevel;
        switch (miningFatigueLevel) {
            case 0: {
                break;
            }
            case 1: {
                speed -= speed * 0.7;
                break;
            }
            case 2: {
                speed -= speed * 0.91;
                break;
            }
            case 3: {
                speed -= speed * 0.9973;
                break;
            }
            default: {
                speed -= speed * 0.99919;
            }
        }
        if (insideOfWaterWithoutAquaAffinity) {
            speed *= 0.2;
        }
        if (!onGround) {
            speed *= 0.2;
        }
        return 1.0 / speed;
    }

    public static double getBreakTime(GeyserSession session, BlockMapping blockMapping, ItemMapping item, @Nullable CompoundTag nbtData, boolean isSessionPlayer) {
        boolean isShearsEffective = session.getTagCache().isShearsEffective(blockMapping);
        boolean canHarvestWithHand = blockMapping.isCanBreakWithHand();
        String toolType = "";
        String toolTier = "";
        boolean correctTool = false;
        boolean toolCanBreak = false;
        if (item.isTool()) {
            toolType = item.getToolType();
            toolTier = item.getToolTier();
            correctTool = BlockUtils.correctTool(session, blockMapping, toolType);
            toolCanBreak = BlockUtils.canToolTierBreakBlock(session, blockMapping, toolTier);
        }
        int toolEfficiencyLevel = ItemUtils.getEnchantmentLevel(nbtData, "minecraft:efficiency");
        int hasteLevel = 0;
        int miningFatigueLevel = 0;
        if (!isSessionPlayer) {
            return BlockUtils.calculateBreakTime(blockMapping.getHardness(), toolTier, canHarvestWithHand, correctTool, toolCanBreak, toolType, isShearsEffective, toolEfficiencyLevel, hasteLevel, miningFatigueLevel, false, true);
        }
        hasteLevel = Math.max(session.getEffectCache().getHaste(), session.getEffectCache().getConduitPower());
        miningFatigueLevel = session.getEffectCache().getMiningFatigue();
        boolean waterInEyes = session.getCollisionManager().isWaterInEyes();
        boolean insideOfWaterWithoutAquaAffinity = waterInEyes && ItemUtils.getEnchantmentLevel(session.getPlayerInventory().getItem(5).getNbt(), "minecraft:aqua_affinity") < 1;
        return BlockUtils.calculateBreakTime(blockMapping.getHardness(), toolTier, canHarvestWithHand, correctTool, toolCanBreak, toolType, isShearsEffective, toolEfficiencyLevel, hasteLevel, miningFatigueLevel, insideOfWaterWithoutAquaAffinity, session.getPlayerEntity().isOnGround());
    }

    public static double getSessionBreakTime(GeyserSession session, BlockMapping blockMapping) {
        PlayerInventory inventory = session.getPlayerInventory();
        GeyserItemStack item = inventory.getItemInHand();
        ItemMapping mapping = ItemMapping.AIR;
        CompoundTag nbtData = null;
        if (item != null) {
            mapping = item.getMapping(session);
            nbtData = item.getNbt();
        }
        return BlockUtils.getBreakTime(session, blockMapping, mapping, nbtData, true);
    }

    public static Vector3i getBlockPosition(Vector3i blockPos, int face) {
        return switch (face) {
            case 0 -> blockPos.sub(0, 1, 0);
            case 1 -> blockPos.add(0, 1, 0);
            case 2 -> blockPos.sub(0, 0, 1);
            case 3 -> blockPos.add(0, 0, 1);
            case 4 -> blockPos.sub(1, 0, 0);
            case 5 -> blockPos.add(1, 0, 0);
            default -> blockPos;
        };
    }

    public static String getCleanIdentifier(String fullJavaIdentifier) {
        int stateIndex = fullJavaIdentifier.indexOf(91);
        if (stateIndex == -1) {
            return fullJavaIdentifier;
        }
        return fullJavaIdentifier.substring(0, stateIndex);
    }

    public static BlockCollision getCollision(int blockId) {
        return BlockRegistries.COLLISIONS.get(blockId);
    }

    public static BlockCollision getCollisionAt(GeyserSession session, Vector3i blockPos) {
        return BlockUtils.getCollision(session.getGeyser().getWorldManager().getBlockAt(session, blockPos));
    }

    public static BlockCollision getCollisionAt(GeyserSession session, int x, int y, int z) {
        return BlockUtils.getCollision(session.getGeyser().getWorldManager().getBlockAt(session, x, y, z));
    }

    private BlockUtils() {
    }
}

