/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.statistic.StatisticFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.IntFunction;

public final class StatisticFormatters {
    private static final Map<StatisticFormat, IntFunction<String>> FORMATTERS = new EnumMap<StatisticFormat, IntFunction<String>>(StatisticFormat.class);
    private static final DecimalFormat FORMAT = new DecimalFormat("###,###,##0.00");
    public static final IntFunction<String> INTEGER = NumberFormat.getIntegerInstance(Locale.US)::format;

    public static IntFunction<String> get(StatisticFormat format) {
        return FORMATTERS.getOrDefault((Object)format, INTEGER);
    }

    private StatisticFormatters() {
    }

    static {
        FORMATTERS.put(StatisticFormat.INTEGER, INTEGER);
        FORMATTERS.put(StatisticFormat.TENTHS, value -> FORMAT.format((double)value / 10.0));
        FORMATTERS.put(StatisticFormat.DISTANCE, centimeter -> {
            double meter = (double)centimeter / 100.0;
            double kilometer = meter / 1000.0;
            if (kilometer > 0.5) {
                return FORMAT.format(kilometer) + " km";
            }
            if (meter > 0.5) {
                return FORMAT.format(meter) + " m";
            }
            return centimeter + " cm";
        });
        FORMATTERS.put(StatisticFormat.TIME, ticks -> {
            double seconds = (double)ticks / 20.0;
            double minutes = seconds / 60.0;
            double hours = minutes / 60.0;
            double days = hours / 24.0;
            double years = days / 365.0;
            if (years > 0.5) {
                return FORMAT.format(years) + " y";
            }
            if (days > 0.5) {
                return FORMAT.format(days) + " d";
            }
            if (hours > 0.5) {
                return FORMAT.format(hours) + " h";
            }
            if (minutes > 0.5) {
                return FORMAT.format(minutes) + " m";
            }
            return FORMAT.format(seconds) + " s";
        });
    }
}

