/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import com.github.steveice10.mc.protocol.data.game.statistic.BreakBlockStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.BreakItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CraftItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.CustomStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.DropItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KillEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.KilledByEntityStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.PickupItemStatistic;
import com.github.steveice10.mc.protocol.data.game.statistic.Statistic;
import com.github.steveice10.mc.protocol.data.game.statistic.UseItemStatistic;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.util.StatisticFormatters;

public class StatisticsUtils {
    private static final Pattern CONTENT_PATTERN = Pattern.compile("^\\S+:", 8);

    public static void buildAndSendStatisticsMenu(GeyserSession session) {
        String language = session.locale();
        session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(StatisticsUtils::translate, language)).title("gui.stats")).button("stat.generalButton", FormImage.Type.PATH, "textures/ui/World").button("stat.itemsButton - stat_type.minecraft.mined", FormImage.Type.PATH, "textures/items/iron_pickaxe").button("stat.itemsButton - stat_type.minecraft.broken", FormImage.Type.PATH, "textures/items/record_11").button("stat.itemsButton - stat_type.minecraft.crafted", FormImage.Type.PATH, "textures/blocks/crafting_table_side").button("stat.itemsButton - stat_type.minecraft.used", FormImage.Type.PATH, "textures/ui/Wrenches1").button("stat.itemsButton - stat_type.minecraft.picked_up", FormImage.Type.PATH, "textures/blocks/chest_front").button("stat.itemsButton - stat_type.minecraft.dropped", FormImage.Type.PATH, "textures/ui/trash_default").button("stat.mobsButton - geyser.statistics.killed", FormImage.Type.PATH, "textures/items/diamond_sword").button("stat.mobsButton - geyser.statistics.killed_by", FormImage.Type.PATH, "textures/ui/wither_heart_flash").validResultHandler(response -> {
            SimpleForm.Builder builder = (SimpleForm.Builder)SimpleForm.builder().translator(StatisticsUtils::translate, language);
            ArrayList<CallSite> content = new ArrayList<CallSite>();
            List itemRegistry = (List)Registries.JAVA_ITEMS.get();
            switch (response.clickedButtonId()) {
                case 0: {
                    Statistic statistic;
                    builder.title("stat.generalButton");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt4498$temp = entry.getKey();
                        if (!(patt4498$temp instanceof CustomStatistic)) continue;
                        statistic = (CustomStatistic)patt4498$temp;
                        String statName = ((Enum)((Object)statistic)).name().toLowerCase(Locale.ROOT);
                        IntFunction<String> formatter = StatisticFormatters.get(((CustomStatistic)statistic).getFormat());
                        content.add((CallSite)((Object)("stat.minecraft." + statName + ": " + formatter.apply(entry.getIntValue()))));
                    }
                    break;
                }
                case 1: {
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.mined");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        String identifier;
                        Object patt5350$temp = entry.getKey();
                        if (!(patt5350$temp instanceof BreakBlockStatistic) || (identifier = BlockRegistries.CLEAN_JAVA_IDENTIFIERS.get(((BreakBlockStatistic)(statistic = (BreakBlockStatistic)patt5350$temp)).getId())) == null) continue;
                        String block = identifier.replace("minecraft:", "block.minecraft.");
                        content.add((CallSite)((Object)(block + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 2: {
                    String item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.broken");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt6302$temp = entry.getKey();
                        if (!(patt6302$temp instanceof BreakItemStatistic)) continue;
                        statistic = (BreakItemStatistic)patt6302$temp;
                        item = ((Item)itemRegistry.get(((BreakItemStatistic)statistic).getId())).javaIdentifier();
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 3: {
                    String item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.crafted");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt7032$temp = entry.getKey();
                        if (!(patt7032$temp instanceof CraftItemStatistic)) continue;
                        statistic = (CraftItemStatistic)patt7032$temp;
                        item = ((Item)itemRegistry.get(((CraftItemStatistic)statistic).getId())).javaIdentifier();
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 4: {
                    String item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.used");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt7759$temp = entry.getKey();
                        if (!(patt7759$temp instanceof UseItemStatistic)) continue;
                        statistic = (UseItemStatistic)patt7759$temp;
                        item = ((Item)itemRegistry.get(((UseItemStatistic)statistic).getId())).javaIdentifier();
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 5: {
                    String item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.picked_up");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt8489$temp = entry.getKey();
                        if (!(patt8489$temp instanceof PickupItemStatistic)) continue;
                        statistic = (PickupItemStatistic)patt8489$temp;
                        item = ((Item)itemRegistry.get(((PickupItemStatistic)statistic).getId())).javaIdentifier();
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 6: {
                    String item;
                    Statistic statistic;
                    builder.title("stat.itemsButton - stat_type.minecraft.dropped");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt9220$temp = entry.getKey();
                        if (!(patt9220$temp instanceof DropItemStatistic)) continue;
                        statistic = (DropItemStatistic)patt9220$temp;
                        item = ((Item)itemRegistry.get(((DropItemStatistic)statistic).getId())).javaIdentifier();
                        content.add((CallSite)((Object)(StatisticsUtils.getItemTranslateKey(item, language) + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 7: {
                    String entityName;
                    Statistic statistic;
                    builder.title("stat.mobsButton - geyser.statistics.killed");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt9945$temp = entry.getKey();
                        if (!(patt9945$temp instanceof KillEntityStatistic)) continue;
                        statistic = (KillEntityStatistic)patt9945$temp;
                        entityName = ((KillEntityStatistic)statistic).getEntity().name().toLowerCase(Locale.ROOT);
                        content.add((CallSite)((Object)("entity.minecraft." + entityName + ": " + entry.getIntValue())));
                    }
                    break;
                }
                case 8: {
                    String entityName;
                    Statistic statistic;
                    builder.title("stat.mobsButton - geyser.statistics.killed_by");
                    for (Object2IntMap.Entry entry : session.getStatistics().object2IntEntrySet()) {
                        Object patt10679$temp = entry.getKey();
                        if (!(patt10679$temp instanceof KilledByEntityStatistic)) continue;
                        statistic = (KilledByEntityStatistic)patt10679$temp;
                        entityName = ((KilledByEntityStatistic)statistic).getEntity().name().toLowerCase(Locale.ROOT);
                        content.add((CallSite)((Object)("entity.minecraft." + entityName + ": " + entry.getIntValue())));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            StringBuilder assembledContent = new StringBuilder();
            if (content.size() == 0) {
                assembledContent.append("geyser.statistics.none");
            } else {
                void var7_18;
                content.replaceAll(x -> StatisticsUtils.translate(x, language));
                content.sort(String::compareTo);
                boolean bl = false;
                while (var7_18 < content.size()) {
                    assembledContent.append((String)content.get((int)var7_18));
                    if (var7_18 % 2 == false) {
                        assembledContent.append("\u00a77\n");
                    } else {
                        assembledContent.append("\u00a7r\n");
                    }
                    ++var7_18;
                }
            }
            session.sendForm((FormBuilder<?, ?, ?>)builder.content(assembledContent.toString()).button("gui.back", FormImage.Type.PATH, "textures/gui/newgui/undo").validResultHandler(response1 -> StatisticsUtils.buildAndSendStatisticsMenu(session)));
        }));
    }

    private static String getItemTranslateKey(String item, String language) {
        String translatedItem = MinecraftLocale.getLocaleString(item = item.replace("minecraft:", "item.minecraft."), language);
        if (translatedItem.equals(item)) {
            translatedItem = MinecraftLocale.getLocaleString(item.replace("item.", "block."), language);
        }
        return translatedItem;
    }

    private static String translate(String keys, String locale) {
        Matcher matcher = CONTENT_PATTERN.matcher(keys);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(buffer, StatisticsUtils.translateEntry(group.substring(0, group.length() - 1), locale) + ":");
        }
        if (buffer.length() != 0) {
            return matcher.appendTail(buffer).toString();
        }
        CharSequence[] keySplitted = keys.split(" - ");
        for (int i = 0; i < keySplitted.length; ++i) {
            keySplitted[i] = StatisticsUtils.translateEntry((String)keySplitted[i], locale);
        }
        return String.join((CharSequence)" - ", keySplitted);
    }

    private static String translateEntry(String key, String locale) {
        if (key.startsWith("geyser.")) {
            return GeyserLocale.getPlayerLocaleString(key, locale);
        }
        return MinecraftLocale.getLocaleString(key, locale);
    }
}

