/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.listeners;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceChangedEvent;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Teleporters.CMITeleporter;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityToggleGlideEvent;

public class ResidencePlayerListener1_9
implements Listener {
    private Residence plugin;

    public ResidencePlayerListener1_9(Residence plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void EntityToggleGlideEvent(EntityToggleGlideEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (this.plugin.isResAdminOn((CommandSender)event.getEntity())) {
            return;
        }
        Player player = (Player)event.getEntity();
        FlagPermissions perms = this.plugin.getPermsByLocForPlayer(player.getLocation(), player);
        if (perms.playerHas(player, Flags.elytra, FlagPermissions.FlagCombo.TrueOrNone)) {
            return;
        }
        this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.elytra});
        event.setCancelled(true);
        CMIScheduler.runAtEntityLater((Entity)player, () -> player.setGliding(false), (long)2L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceChange(ResidenceChangedEvent event) {
        ClaimedResidence newRes = event.getTo();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.isGliding()) {
            return;
        }
        if (newRes == null) {
            return;
        }
        if (newRes.getPermissions().playerHas(player, Flags.elytra, FlagPermissions.FlagCombo.TrueOrNone)) {
            return;
        }
        player.setGliding(false);
        Location loc = ResidencePlayerListener.getSafeLocation(player.getLocation());
        if (loc == null && (loc = this.plugin.getConfigManager().getFlyLandLocation()) == null) {
            loc = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
        }
        if (loc != null) {
            this.plugin.msg((CommandSender)player, lm.Flag_Deny, new Object[]{Flags.elytra});
            player.closeInventory();
            CMITeleporter.teleportAsync((Entity)player, (Location)loc);
        }
    }
}

