/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.ConfigManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.chat.ChatChannel;
import com.bekvon.bukkit.residence.commands.padd;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeMessages;
import com.bekvon.bukkit.residence.containers.RandomLoc;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.ResidenceBank;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceAreaAddEvent;
import com.bekvon.bukkit.residence.event.ResidenceAreaDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceSizeChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceSubzoneCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceTPEvent;
import com.bekvon.bukkit.residence.itemlist.ItemList;
import com.bekvon.bukkit.residence.itemlist.ResidenceItemList;
import com.bekvon.bukkit.residence.listeners.ResidencePlayerListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.raid.ResidenceRaid;
import com.bekvon.bukkit.residence.shopStuff.ShopVote;
import com.bekvon.bukkit.residence.signsStuff.Signs;
import com.bekvon.bukkit.residence.utils.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.TitleMessages.CMITitleMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Teleporters.CMITeleporter;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ClaimedResidence {
    private String resName = null;
    protected ClaimedResidence parent;
    protected Map<String, CuboidArea> areas;
    protected Map<String, ClaimedResidence> subzones;
    protected ResidencePermissions perms;
    protected ResidenceBank bank;
    protected double BlockSellPrice = 0.0;
    protected Vector tpLoc;
    protected Vector PitchYaw;
    protected String enterMessage = null;
    protected String leaveMessage = null;
    protected String ShopDesc = null;
    protected String ChatPrefix = "";
    protected CMIChatColor ChannelColor = CMIChatColor.WHITE;
    protected ResidenceItemList ignorelist;
    protected ResidenceItemList blacklist;
    protected boolean mainRes = false;
    protected long createTime = 0L;
    private long leaseExpireTime = 0L;
    protected List<String> cmdWhiteList = new ArrayList<String>();
    protected List<String> cmdBlackList = new ArrayList<String>();
    List<ShopVote> ShopVoteList = new ArrayList<ShopVote>();
    protected RentableLand rentableland = null;
    protected RentedLand rentedland = null;
    protected int sellPrice = -1;
    private ResidenceRaid raid;
    private Set<Signs> signsInResidence = Collections.synchronizedSet(new HashSet());

    public String getResidenceName() {
        return this.resName;
    }

    public void setName(String name) {
        this.resName = name.contains(".") ? name.split("\\.")[name.split("\\.").length - 1] : name;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public Integer getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(Integer amount) {
        this.sellPrice = amount;
    }

    public boolean isForSell() {
        return Residence.getInstance().getTransactionManager().isForSale(this.getName());
    }

    public boolean isForRent() {
        return Residence.getInstance().getRentManager().isForRent(this);
    }

    public boolean isSubzoneForRent() {
        for (Map.Entry<String, ClaimedResidence> one : this.subzones.entrySet()) {
            if (one.getValue().isForRent()) {
                return true;
            }
            if (!one.getValue().isSubzoneForRent()) continue;
            return true;
        }
        return false;
    }

    public boolean isSubzoneRented() {
        for (Map.Entry<String, ClaimedResidence> one : this.subzones.entrySet()) {
            if (one.getValue().isRented()) {
                return true;
            }
            if (!one.getValue().isSubzoneRented()) continue;
            return true;
        }
        return false;
    }

    public ClaimedResidence getRentedSubzone() {
        for (Map.Entry<String, ClaimedResidence> one : this.subzones.entrySet()) {
            if (one.getValue().isRented()) {
                return one.getValue();
            }
            if (one.getValue().getRentedSubzone() == null) continue;
            return one.getValue().getRentedSubzone();
        }
        return null;
    }

    public boolean isParentForRent() {
        if (this.getParent() != null) {
            return this.getParent().isForRent() ? true : this.getParent().isParentForRent();
        }
        return false;
    }

    public boolean isParentForSell() {
        if (this.getParent() != null) {
            return this.getParent().isForSell() ? true : this.getParent().isParentForSell();
        }
        return false;
    }

    public boolean isRented() {
        return Residence.getInstance().getRentManager().isRented(this);
    }

    public void setRentable(RentableLand rl) {
        this.rentableland = rl;
    }

    public RentableLand getRentable() {
        return this.rentableland;
    }

    public void setRented(RentedLand rl) {
        this.rentedland = rl;
    }

    public RentedLand getRentedLand() {
        return this.rentedland;
    }

    public ClaimedResidence() {
        this.initialize();
    }

    public ClaimedResidence(String creationWorld) {
        this(Residence.getInstance().getServerLandName(), creationWorld);
    }

    public ClaimedResidence(String creator, UUID uuid, String creationWorld) {
        this.perms = new ResidencePermissions(this, creator, uuid, creationWorld);
        this.initialize();
    }

    @Deprecated
    public ClaimedResidence(String creator, String creationWorld) {
        this.perms = new ResidencePermissions(this, creator, creationWorld);
        this.initialize();
    }

    public ClaimedResidence(String creator, String creationWorld, ClaimedResidence parentResidence) {
        this(creator, creationWorld);
        this.parent = parentResidence;
    }

    private void initialize() {
        this.subzones = new HashMap<String, ClaimedResidence>();
        this.areas = new HashMap<String, CuboidArea>();
        this.bank = new ResidenceBank(this);
        this.blacklist = new ResidenceItemList(Residence.getInstance(), this, ItemList.ListType.BLACKLIST);
        this.ignorelist = new ResidenceItemList(Residence.getInstance(), this, ItemList.ListType.IGNORELIST);
    }

    public boolean isMainResidence() {
        return this.mainRes;
    }

    public void setMainResidence(boolean state) {
        this.mainRes = state;
    }

    public boolean isSubzone() {
        return this.getParent() != null;
    }

    public int getSubzoneDeep() {
        return this.getSubzoneDeep(0);
    }

    public int getSubzoneDeep(int deep) {
        ++deep;
        if (this.getParent() != null) {
            return this.getParent().getSubzoneDeep(deep);
        }
        return deep;
    }

    public boolean isBiggerThanMin(Player player, CuboidArea area2, boolean resadmin2) {
        if (resadmin2) {
            return true;
        }
        if (player == null) {
            return true;
        }
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (area2.getXSize() < group.getMinX()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallX, area2.getXSize(), group.getMinX());
            return false;
        }
        if (area2.getYSize() < group.getMinY()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallY, area2.getYSize(), group.getMinY());
            return false;
        }
        if (area2.getZSize() < group.getMinZ()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallZ, area2.getZSize(), group.getMinZ());
            return false;
        }
        return true;
    }

    public boolean isBiggerThanMinSubzone(Player player, CuboidArea area2, boolean resadmin2) {
        if (resadmin2) {
            return true;
        }
        if (player == null) {
            return true;
        }
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (area2.getXSize() < group.getSubzoneMinX()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallX, area2.getXSize(), group.getSubzoneMinX());
            return false;
        }
        if (area2.getYSize() < group.getSubzoneMinY()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallY, area2.getYSize(), group.getSubzoneMinY());
            return false;
        }
        if (area2.getZSize() < group.getSubzoneMinZ()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToSmallZ, area2.getZSize(), group.getSubzoneMinZ());
            return false;
        }
        return true;
    }

    public boolean isSmallerThanMax(Player player, CuboidArea area2, boolean resadmin2) {
        if (resadmin2) {
            return true;
        }
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (area2.getXSize() > rPlayer.getMaxX()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigX, area2.getXSize(), rPlayer.getMaxX());
            return false;
        }
        if (area2.getYSize() > group.getMaxY() + -group.getMinY()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigY, area2.getYSize(), group.getMaxY());
            return false;
        }
        if (area2.getZSize() > rPlayer.getMaxZ()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigZ, area2.getZSize(), rPlayer.getMaxZ());
            return false;
        }
        return true;
    }

    public boolean isSmallerThanMaxSubzone(Player player, CuboidArea area2, boolean resadmin2) {
        if (resadmin2) {
            return true;
        }
        ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (area2.getXSize() > group.getSubzoneMaxX()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigX, area2.getXSize(), group.getSubzoneMaxX());
            return false;
        }
        if (area2.getYSize() > group.getSubzoneMaxY() + -group.getMinY()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigY, area2.getYSize(), group.getSubzoneMaxY());
            return false;
        }
        if (area2.getZSize() > group.getSubzoneMaxZ()) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_ToBigZ, area2.getZSize(), group.getSubzoneMaxZ());
            return false;
        }
        return true;
    }

    public boolean addArea(CuboidArea area2, String name) {
        return this.addArea(null, area2, name, true);
    }

    public boolean addArea(Player player, CuboidArea area2, String name, boolean resadmin2) {
        return this.addArea(player, area2, name, resadmin2, true);
    }

    public boolean addArea(Player player, CuboidArea area2, String name, boolean resadmin2, boolean chargeMoney) {
        if (!Residence.getInstance().validName(name)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            }
            return false;
        }
        if (Math.abs(area2.getLowVector().getBlockX()) > 30000000 || Math.abs(area2.getHighVector().getBlockX()) > 30000000 || Math.abs(area2.getLowVector().getBlockZ()) > 30000000 || Math.abs(area2.getHighVector().getBlockZ()) > 30000000) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
            }
            return false;
        }
        String NName = name;
        name = name.toLowerCase();
        if (this.areas.containsKey(NName)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_Exists, new Object[0]);
            }
            return false;
        }
        if (this.isSubzone() && !this.isBiggerThanMinSubzone(player, area2, resadmin2) || !this.isSubzone() && !this.isBiggerThanMin(player, area2, resadmin2)) {
            return false;
        }
        if (!resadmin2 && Residence.getInstance().getConfigManager().getEnforceAreaInsideArea() && this.getParent() == null) {
            boolean inside = false;
            for (CuboidArea are : this.areas.values()) {
                if (!are.isAreaWithinArea(area2)) continue;
                inside = true;
            }
            if (!inside) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_SelectInside, new Object[0]);
                return false;
            }
        }
        if (!area2.getWorld().getName().equalsIgnoreCase(this.perms.getWorldName())) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_DiffWorld, new Object[0]);
            }
            return false;
        }
        if (this.getParent() == null) {
            String collideResidence = Residence.getInstance().getResidenceManager().checkAreaCollision(area2, this);
            ClaimedResidence cRes = Residence.getInstance().getResidenceManager().getByName(collideResidence);
            if (cRes != null) {
                if (player != null) {
                    Residence.getInstance().msg((CommandSender)player, lm.Area_Collision, cRes.getName());
                    Visualizer v = new Visualizer(player);
                    v.setAreas(area2);
                    v.setErrorAreas(cRes);
                    Residence.getInstance().getSelectionManager().showBounds(player, v);
                }
                return false;
            }
            if (Residence.getInstance().getConfigManager().getAntiGreefRangeGaps(area2.getWorldName()) > 0) {
                Location low = area2.getLowLocation().clone();
                Location high = area2.getHighLocation().clone();
                int gap = Residence.getInstance().getConfigManager().getAntiGreefRangeGaps(area2.getWorldName());
                low.add((double)(-gap), (double)(-gap), (double)(-gap));
                high.add((double)gap, (double)gap, (double)gap);
                CuboidArea expanded = new CuboidArea(low, high);
                collideResidence = Residence.getInstance().getResidenceManager().checkAreaCollision(expanded, this, player == null ? null : player.getUniqueId());
                cRes = Residence.getInstance().getResidenceManager().getByName(collideResidence);
                if (cRes != null) {
                    if (player != null) {
                        Residence.getInstance().msg((CommandSender)player, lm.Area_TooClose, gap, cRes.getName());
                        Visualizer v = new Visualizer(player);
                        v.setAreas(area2);
                        v.setErrorAreas(cRes);
                        Residence.getInstance().getSelectionManager().showBounds(player, v);
                    }
                    return false;
                }
            }
        } else {
            String[] szs;
            String[] stringArray = szs = this.getParent().listSubzones();
            int n = szs.length;
            int low = 0;
            while (low < n) {
                String sz = stringArray[low];
                ClaimedResidence res = this.getParent().getSubzone(sz);
                if (res != null && res != this && res.checkCollision(area2)) {
                    if (player != null) {
                        Residence.getInstance().msg((CommandSender)player, lm.Area_SubzoneCollision, sz);
                    }
                    return false;
                }
                ++low;
            }
        }
        if (!resadmin2 && player != null) {
            if (!this.perms.hasResidencePermission((CommandSender)player, true)) {
                Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.getParent() != null) {
                if (!this.getParent().containsLoc(area2.getHighLocation()) || !this.getParent().containsLoc(area2.getLowLocation())) {
                    Residence.getInstance().msg((CommandSender)player, lm.Area_NotWithinParent, new Object[0]);
                    return false;
                }
                if (!this.getParent().getPermissions().hasResidencePermission((CommandSender)player, true) && !this.getParent().getPermissions().playerHas(player, Flags.subzone, FlagPermissions.FlagCombo.OnlyTrue)) {
                    Residence.getInstance().msg((CommandSender)player, lm.Residence_ParentNoPermission, new Object[0]);
                    return false;
                }
            }
            ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
            PermissionGroup group = rPlayer.getGroup();
            if (!this.isSubzone() && !group.canCreateResidences() && !PermissionManager.ResPerm.create.hasPermission((CommandSender)player, true, new String[0]) || this.isSubzone() && !group.canCreateResidences() && !PermissionManager.ResPerm.create_subzone.hasPermission((CommandSender)player, true, new String[0])) {
                return false;
            }
            if (this.areas.size() >= group.getMaxPhysicalPerResidence()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_MaxPhysical, new Object[0]);
                return false;
            }
            if (!this.isSubzone() && !this.isSmallerThanMax(player, area2, resadmin2) || this.isSubzone() && !this.isSmallerThanMaxSubzone(player, area2, resadmin2)) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_SizeLimit, new Object[0]);
                return false;
            }
            if (group.getMinHeight() > area2.getLowVector().getBlockY()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_LowLimit, String.format("%d", group.getMinHeight()));
                return false;
            }
            if (group.getMaxHeight() < area2.getHighVector().getBlockY()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_HighLimit, String.format("%d", group.getMaxHeight()));
                return false;
            }
            if (!resadmin2) {
                if (Residence.getInstance().getWorldGuard() != null && Residence.getInstance().getWorldGuardUtil().isSelectionInArea(player)) {
                    return false;
                }
                if (Residence.getInstance().getKingdomsManager() != null && Residence.getInstance().getKingdomsUtil().isSelectionInArea(player)) {
                    return false;
                }
            }
            if (Residence.getInstance().getConfigManager().isChargeOnAreaAdd() && chargeMoney && this.getParent() == null && Residence.getInstance().getConfigManager().enableEconomy() && !resadmin2) {
                double chargeamount = area2.getCost(group);
                if (!Residence.getInstance().getTransactionManager().chargeEconomyMoney(player, chargeamount)) {
                    return false;
                }
            }
        }
        ResidenceAreaAddEvent resevent = new ResidenceAreaAddEvent(player, NName, this, area2);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        Residence.getInstance().getResidenceManager().removeChunkList(this.getName());
        this.areas.put(name, area2);
        Residence.getInstance().getResidenceManager().calculateChunks(this.getName());
        return true;
    }

    public boolean replaceArea(CuboidArea neware, String name) {
        return this.replaceArea(null, neware, name, true);
    }

    public boolean replaceArea(Player player, CuboidArea newarea, String name, boolean resadmin2) {
        int chargeamount;
        ClaimedResidence res;
        String sz;
        String[] szs;
        if (!this.areas.containsKey(name)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
            }
            return false;
        }
        CuboidArea oldarea = this.areas.get(name);
        if (!newarea.getWorld().getName().equalsIgnoreCase(this.perms.getWorldName())) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_DiffWorld, new Object[0]);
            }
            return false;
        }
        if (this.getParent() == null) {
            String collideResidence = Residence.getInstance().getResidenceManager().checkAreaCollision(newarea, this);
            ClaimedResidence cRes = Residence.getInstance().getResidenceManager().getByName(collideResidence);
            if (cRes != null && player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_Collision, cRes.getName());
                Visualizer v = new Visualizer(player);
                v.setAreas(this.getAreaArray());
                v.setErrorAreas(cRes.getAreaArray());
                Residence.getInstance().getSelectionManager().showBounds(player, v);
                return false;
            }
            if (Residence.getInstance().getConfigManager().getAntiGreefRangeGaps(newarea.getWorldName()) > 0) {
                Location low = newarea.getLowLocation().clone();
                Location high = newarea.getHighLocation().clone();
                int gap = Residence.getInstance().getConfigManager().getAntiGreefRangeGaps(newarea.getWorldName());
                low.add((double)(-gap), (double)(-gap), (double)(-gap));
                high.add((double)gap, (double)gap, (double)gap);
                CuboidArea expanded = new CuboidArea(low, high);
                collideResidence = Residence.getInstance().getResidenceManager().checkAreaCollision(expanded, this, player == null ? null : player.getUniqueId());
                cRes = Residence.getInstance().getResidenceManager().getByName(collideResidence);
                if (cRes != null) {
                    if (player != null) {
                        Residence.getInstance().msg((CommandSender)player, lm.Area_TooClose, gap, cRes.getName());
                        Visualizer v = new Visualizer(player);
                        v.setAreas(this.getAreaArray());
                        v.setErrorAreas(cRes);
                        Residence.getInstance().getSelectionManager().showBounds(player, v);
                    }
                    return false;
                }
            }
        } else {
            String[] stringArray = szs = this.getParent().listSubzones();
            int high = szs.length;
            int low = 0;
            while (low < high) {
                sz = stringArray[low];
                res = this.getParent().getSubzone(sz);
                if (res != null && res != this && res.checkCollision(newarea)) {
                    if (player != null) {
                        Residence.getInstance().msg((CommandSender)player, lm.Area_SubzoneCollision, sz);
                        Visualizer v = new Visualizer(player);
                        v.setErrorAreas(res.getAreaArray());
                        Residence.getInstance().getSelectionManager().showBounds(player, v);
                    }
                    return false;
                }
                ++low;
            }
        }
        String[] stringArray = szs = this.listSubzones();
        int high = szs.length;
        int low = 0;
        while (low < high) {
            sz = stringArray[low];
            res = this.getSubzone(sz);
            if (res != null && res != this) {
                String[] szareas;
                String[] stringArray2 = szareas = res.getAreaList();
                int n = szareas.length;
                int n2 = 0;
                while (n2 < n) {
                    String area2 = stringArray2[n2];
                    if (!newarea.isAreaWithinArea(res.getArea(area2))) {
                        boolean good = false;
                        CuboidArea[] cuboidAreaArray = this.getAreaArray();
                        int n3 = cuboidAreaArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            CuboidArea arae = cuboidAreaArray[n4];
                            if (arae != oldarea && arae.isAreaWithinArea(res.getArea(area2))) {
                                good = true;
                            }
                            ++n4;
                        }
                        if (!good) {
                            Residence.getInstance().msg((CommandSender)player, lm.Area_Collision, res.getName());
                            Visualizer v = new Visualizer(player);
                            v.setAreas(this.getAreaArray());
                            v.setErrorAreas(res.getAreaArray());
                            Residence.getInstance().getSelectionManager().showBounds(player, v);
                            return false;
                        }
                    }
                    ++n2;
                }
                if (res.getAreaArray().length == 0) {
                    this.removeSubzone(sz);
                }
            }
            ++low;
        }
        if (!resadmin2 && player != null) {
            double chargeamount2;
            ResidencePlayer rPlayer;
            PermissionGroup group;
            if (!this.getPermissions().hasResidencePermission((CommandSender)player, true) && !this.getPermissions().playerHas(player, Flags.admin, FlagPermissions.FlagCombo.OnlyTrue)) {
                Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.getParent() != null) {
                if (!this.getParent().containsLoc(newarea.getHighLocation()) || !this.getParent().containsLoc(newarea.getLowLocation())) {
                    Residence.getInstance().msg((CommandSender)player, lm.Area_NotWithinParent, new Object[0]);
                    return false;
                }
                if (!this.getParent().getPermissions().hasResidencePermission((CommandSender)player, true) && !this.getParent().getPermissions().playerHas(player, Flags.subzone, FlagPermissions.FlagCombo.OnlyTrue)) {
                    Residence.getInstance().msg((CommandSender)player, lm.Residence_ParentNoPermission, new Object[0]);
                    return false;
                }
            }
            if (!(group = (rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player)).getGroup()).canCreateResidences() && !PermissionManager.ResPerm.resize.hasPermission((CommandSender)player, true, new String[0])) {
                return false;
            }
            if (oldarea.getSize() < newarea.getSize() && (!this.isSubzone() && !this.isSmallerThanMax(player, newarea, resadmin2) || this.isSubzone() && !this.isSmallerThanMaxSubzone(player, newarea, resadmin2))) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_SizeLimit, new Object[0]);
                return false;
            }
            if (group.getMinHeight() > newarea.getLowVector().getBlockY()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_LowLimit, String.format("%d", group.getMinHeight()));
                return false;
            }
            if (group.getMaxHeight() < newarea.getHighVector().getBlockY()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_HighLimit, String.format("%d", group.getMaxHeight()));
                return false;
            }
            if (!this.isBiggerThanMin(player, newarea, resadmin2)) {
                return false;
            }
            if (!resadmin2) {
                if (Residence.getInstance().getWorldGuard() != null && Residence.getInstance().getWorldGuardUtil().isSelectionInArea(player)) {
                    return false;
                }
                if (Residence.getInstance().getKingdomsManager() != null && Residence.getInstance().getKingdomsUtil().isSelectionInArea(player)) {
                    return false;
                }
            }
            if (Residence.getInstance().getConfigManager().isChargeOnExpansion() && this.getParent() == null && Residence.getInstance().getConfigManager().enableEconomy() && !resadmin2 && (chargeamount2 = newarea.getCost(group) - oldarea.getCost(group)) > 0.0 && !Residence.getInstance().getTransactionManager().chargeEconomyMoney(player, chargeamount2)) {
                return false;
            }
        }
        ResidenceSizeChangeEvent resevent = new ResidenceSizeChangeEvent(player, this, oldarea, newarea);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        if (!resadmin2 && player != null && (chargeamount = (int)Math.ceil((double)(newarea.getSize() - oldarea.getSize()) * this.getBlockSellPrice())) < 0 && Residence.getInstance().getConfigManager().useResMoneyBack() && !this.isServerLand()) {
            Residence.getInstance().getTransactionManager().giveEconomyMoney(player, (double)(-chargeamount));
        }
        Residence.getInstance().getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(name);
        this.areas.put(name, newarea);
        Residence.getInstance().getResidenceManager().calculateChunks(this.getName());
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_Update, new Object[0]);
        }
        return true;
    }

    public boolean addSubzone(String name, Location loc1, Location loc2) {
        return this.addSubzone(null, loc1, loc2, name, true);
    }

    public boolean addSubzone(Player player, Location loc1, Location loc2, String name, boolean resadmin2) {
        if (player == null) {
            return this.addSubzone(null, Residence.getInstance().getServerLandName(), loc1, loc2, name, resadmin2);
        }
        return this.addSubzone(player, player.getName(), loc1, loc2, name, resadmin2);
    }

    public boolean isServerLand() {
        return this.getOwnerUUID().toString().equals(Residence.getInstance().getServerLandUUID());
    }

    public boolean addSubzone(Player player, String name, boolean resadmin2) {
        if (Residence.getInstance().getSelectionManager().hasPlacedBoth(player)) {
            Location loc1 = Residence.getInstance().getSelectionManager().getPlayerLoc1(player);
            Location loc2 = Residence.getInstance().getSelectionManager().getPlayerLoc2(player);
            return this.addSubzone(player, player.getName(), loc1, loc2, name, resadmin2);
        }
        return false;
    }

    public boolean addSubzone(Player player, String owner, Location loc1, Location loc2, String name, boolean resadmin2) {
        ClaimedResidence newres;
        if (!Residence.getInstance().validName(name)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            }
            return false;
        }
        if (!this.containsLoc(loc1) || !this.containsLoc(loc2)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_SelectInside, new Object[0]);
            }
            return false;
        }
        String NName = name;
        if (this.subzones.containsKey(name = name.toLowerCase())) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_Exists, NName);
            }
            return false;
        }
        if (!resadmin2 && player != null) {
            if (!this.perms.hasResidencePermission((CommandSender)player, true) && !this.perms.playerHas(player.getName(), Flags.subzone, this.perms.playerHas(player, Flags.admin, false))) {
                Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                return false;
            }
            if (this.getSubzoneList().length >= Residence.getInstance().getPlayerManager().getResidencePlayer(owner).getMaxSubzones()) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_MaxAmount, new Object[0]);
                return false;
            }
            if (this.getZoneDepth() >= Residence.getInstance().getPlayerManager().getResidencePlayer(owner).getMaxSubzoneDepth()) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_MaxDepth, new Object[0]);
                return false;
            }
        }
        CuboidArea newArea = new CuboidArea(loc1, loc2);
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> resEntry : set2) {
            ClaimedResidence res = resEntry.getValue();
            if (!res.checkCollision(newArea)) continue;
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_Collide, resEntry.getKey());
                Visualizer v = new Visualizer(player);
                v.setAreas(newArea);
                v.setErrorAreas(res);
                Residence.getInstance().getSelectionManager().showBounds(player, v);
            }
            return false;
        }
        if (player != null) {
            newres = new ClaimedResidence(owner, this.perms.getWorldName(), this);
            newres.addArea(player, newArea, NName, resadmin2);
        } else {
            newres = new ClaimedResidence(owner, this.perms.getWorldName(), this);
            newres.addArea(newArea, NName);
        }
        if (newres.getAreaCount() != 0) {
            newres.getPermissions().applyDefaultFlags();
            if (player != null) {
                ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(player);
                PermissionGroup group = rPlayer.getGroup();
                newres.setEnterMessage(group.getDefaultEnterMessage());
                newres.setLeaveMessage(group.getDefaultLeaveMessage());
            }
            if (Residence.getInstance().getConfigManager().flagsInherit()) {
                newres.getPermissions().setParent(this.perms);
            }
            newres.resName = NName;
            newres.setCreateTime();
            ResidenceSubzoneCreationEvent resevent = new ResidenceSubzoneCreationEvent(player, NName, newres, newArea);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)resevent);
            if (resevent.isCancelled()) {
                return false;
            }
            this.subzones.put(name, newres);
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_Create, NName);
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_Create, NName);
            }
            return true;
        }
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Subzone_CreateFail, NName);
        }
        return false;
    }

    public ClaimedResidence getSubzoneByLoc(Location loc) {
        for (Map.Entry<String, ClaimedResidence> entry : this.subzones.entrySet()) {
            if (!entry.getValue().containsLoc(loc)) continue;
            ClaimedResidence subrez = entry.getValue().getSubzoneByLoc(loc);
            return subrez == null ? entry.getValue() : subrez;
        }
        return null;
    }

    public ClaimedResidence getSubzone(String subzonename) {
        if (!(subzonename = subzonename.toLowerCase()).contains(".")) {
            return this.subzones.get(subzonename);
        }
        String[] split = subzonename.split("\\.");
        ClaimedResidence get = this.subzones.get(split[0]);
        int i = 1;
        while (i < split.length) {
            if (get == null) {
                return null;
            }
            get = get.getSubzone(split[i]);
            ++i;
        }
        return get;
    }

    public String getSubzoneNameByRes(ClaimedResidence res) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.subzones.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            if (entry.getValue() == res) {
                return entry.getValue().getResidenceName();
            }
            String n = entry.getValue().getSubzoneNameByRes(res);
            if (n == null) continue;
            return String.valueOf(entry.getValue().getResidenceName()) + "." + n;
        }
        return null;
    }

    public String[] getSubzoneList() {
        ArrayList<String> zones = new ArrayList<String>();
        Set<String> set2 = this.subzones.keySet();
        for (String key : set2) {
            if (key == null) continue;
            zones.add(key);
        }
        return zones.toArray(new String[zones.size()]);
    }

    public boolean checkCollision(CuboidArea area2) {
        for (CuboidArea checkarea : this.areas.values()) {
            if (checkarea == null || !checkarea.checkCollision(area2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLoc(Location loc) {
        for (CuboidArea key : this.areas.values()) {
            if (!key.containsLoc(loc)) continue;
            if (this.getParent() != null) {
                return this.getParent().containsLoc(loc);
            }
            return true;
        }
        return false;
    }

    public ClaimedResidence getParent() {
        return this.parent;
    }

    public String getTopParentName() {
        return this.getTopParent().getName();
    }

    public ClaimedResidence getTopParent() {
        if (this.getParent() == null) {
            return this;
        }
        return this.getParent().getTopParent();
    }

    public boolean isTopArea() {
        return this.getParent() == null;
    }

    public boolean removeSubzone(String name) {
        return this.removeSubzone(null, name, true);
    }

    public boolean removeSubzone(Player player, String name, boolean resadmin2) {
        if (name == null) {
            return false;
        }
        name = name.toLowerCase();
        ClaimedResidence res = this.subzones.get(name);
        if (player != null && !res.perms.hasResidencePermission((CommandSender)player, true) && !resadmin2) {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return false;
        }
        this.subzones.remove(name);
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Subzone_Remove, name);
        }
        return true;
    }

    public long getTotalSize() {
        Collection<CuboidArea> set2 = this.areas.values();
        long size = 0L;
        if (!Residence.getInstance().getConfigManager().isNoCostForYBlocks()) {
            for (CuboidArea entry : set2) {
                size += entry.getSize();
            }
        } else {
            for (CuboidArea entry : set2) {
                size += (long)(entry.getXSize() * entry.getZSize());
            }
        }
        return size;
    }

    public long getXZSize() {
        Collection<CuboidArea> set2 = this.areas.values();
        long size = 0L;
        for (CuboidArea entry : set2) {
            size += (long)(entry.getXSize() * entry.getZSize());
        }
        return size;
    }

    public CuboidArea[] getAreaArray() {
        return this.areas.values().toArray(new CuboidArea[0]);
    }

    public Map<String, CuboidArea> getAreaMap() {
        return this.areas;
    }

    public ResidencePermissions getPermissions() {
        return this.perms;
    }

    public String getEnterMessage() {
        return this.enterMessage;
    }

    public String getLeaveMessage() {
        return this.leaveMessage;
    }

    public String getShopDesc() {
        return this.ShopDesc;
    }

    public void setEnterMessage(String message2) {
        this.enterMessage = message2;
    }

    public void setLeaveMessage(String message2) {
        this.leaveMessage = message2;
    }

    public void setShopDesc(String message2) {
        this.ShopDesc = message2;
    }

    public void setEnterLeaveMessage(CommandSender sender, String message2, boolean enter, boolean resadmin2) {
        if (message2 != null) {
            message2 = message2.replace("%subtitle%", "\\n");
        }
        if (sender instanceof Player) {
            ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer((Player)sender);
            PermissionGroup group = rPlayer.getGroup();
            if (!group.canSetEnterLeaveMessages() && !resadmin2) {
                Residence.getInstance().msg(sender, lm.Residence_OwnerNoPermission, new Object[0]);
                return;
            }
            if (!this.perms.hasResidencePermission(sender, false) && !resadmin2) {
                Residence.getInstance().msg(sender, lm.General_NoPermission, new Object[0]);
                return;
            }
        }
        if (enter) {
            this.setEnterMessage(message2);
        } else {
            this.setLeaveMessage(message2);
        }
        Residence.getInstance().msg(sender, lm.Residence_MessageChange, new Object[0]);
    }

    public Location getMiddleFreeLoc(Location insideLoc, Player player) {
        return this.getMiddleFreeLoc(insideLoc, player, true);
    }

    public Location getMiddleFreeLoc(Location insideLoc, Player player, boolean toSpawnOnFail) {
        if (insideLoc == null) {
            return null;
        }
        CuboidArea area2 = this.getAreaByLoc(insideLoc);
        if (area2 == null) {
            return insideLoc;
        }
        int y = area2.getHighVector().getBlockY();
        int lowY = area2.getLowVector().getBlockY();
        int x = area2.getLowVector().getBlockX() + area2.getXSize() / 2;
        int z = area2.getLowVector().getBlockZ() + area2.getZSize() / 2;
        Location newLoc = new Location(area2.getWorld(), (double)x + 0.5, (double)y, (double)z + 0.5);
        boolean found = false;
        int it = 1;
        int maxIt = newLoc.getBlockY() + 1;
        try {
            if (!Version.isFolia()) {
                insideLoc.getChunk().setForceLoaded(true);
            }
        }
        catch (Throwable throwable) {}
        try {
            while (it < maxIt) {
                ++it;
                if (newLoc.getBlockY() >= lowY) {
                    newLoc.add(0.0, -1.0, 0.0);
                    Block block = newLoc.getBlock();
                    Block block2 = newLoc.clone().add(0.0, 1.0, 0.0).getBlock();
                    Block block3 = newLoc.clone().add(0.0, -1.0, 0.0).getBlock();
                    if (Version.isFolia()) {
                        found = true;
                    } else {
                        if (!ResidencePlayerListener.isEmptyBlock(block) || !ResidencePlayerListener.isEmptyBlock(block2) || ResidencePlayerListener.isEmptyBlock(block3)) continue;
                        found = true;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!Version.isFolia()) {
                insideLoc.getChunk().setForceLoaded(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (found) {
            if (player != null) {
                newLoc.setPitch(player.getLocation().getPitch());
                newLoc.setYaw(player.getLocation().getYaw());
            }
            return newLoc;
        }
        return this.getOutsideFreeLoc(insideLoc, player, toSpawnOnFail);
    }

    @Deprecated
    public Location getOutsideFreeLoc(Location insideLoc, Player player) {
        return this.getOutsideFreeLoc(insideLoc, player, true);
    }

    public Location getOutsideFreeLoc(Location insideLoc, Player player, boolean toSpawnOnFail) {
        CuboidArea area2 = this.getAreaByLoc(insideLoc);
        if (area2 == null) {
            if (!toSpawnOnFail) {
                return null;
            }
            World bw = this.getPermissions().getBukkitWorld();
            return bw != null ? (bw.getSpawnLocation() != null ? bw.getSpawnLocation() : player.getWorld().getSpawnLocation()) : player.getWorld().getSpawnLocation();
        }
        ArrayList<RandomLoc> randomLocList = new ArrayList<RandomLoc>();
        int z = -1;
        while (z < area2.getZSize() + 2) {
            randomLocList.add(new RandomLoc(area2.getLowVector().getX(), 0.0, area2.getLowVector().getZ() + (double)z));
            randomLocList.add(new RandomLoc(area2.getLowVector().getX() + (double)area2.getXSize(), 0.0, area2.getLowVector().getZ() + (double)z));
            ++z;
        }
        int x = -1;
        while (x < area2.getXSize() + 2) {
            randomLocList.add(new RandomLoc(area2.getLowVector().getX() + (double)x, 0.0, area2.getLowVector().getZ()));
            randomLocList.add(new RandomLoc(area2.getLowVector().getX() + (double)x, 0.0, area2.getLowVector().getZ() + (double)area2.getZSize()));
            ++x;
        }
        Location loc = insideLoc.clone();
        boolean admin = PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)player);
        boolean found = false;
        int it = 0;
        int maxIt = 15;
        while (!found && it < maxIt) {
            ClaimedResidence res;
            ++it;
            Random ran = new Random(System.currentTimeMillis());
            if (randomLocList.isEmpty()) break;
            int check2 = ran.nextInt(randomLocList.size());
            RandomLoc place = (RandomLoc)randomLocList.get(check2);
            randomLocList.remove(check2);
            double x2 = place.getX();
            double z2 = place.getZ();
            loc.setX(x2);
            loc.setZ(z2);
            loc.setY((double)area2.getHighVector().getBlockY());
            int max = area2.getHighVector().getBlockY();
            int i = max = loc.getWorld().getEnvironment() == World.Environment.NETHER ? 100 : max;
            while ((double)i > area2.getLowVector().getY()) {
                loc.setY((double)i);
                Block block = loc.getBlock();
                Block block2 = loc.clone().add(0.0, 1.0, 0.0).getBlock();
                Block block3 = loc.clone().add(0.0, -1.0, 0.0).getBlock();
                if (Version.isFolia()) {
                    found = true;
                    break;
                }
                if (!ResidencePlayerListener.isEmptyBlock(block3) && ResidencePlayerListener.isEmptyBlock(block) && ResidencePlayerListener.isEmptyBlock(block2)) break;
                --i;
            }
            if (!ResidencePlayerListener.isEmptyBlock(loc.getBlock()) || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.LAVA || loc.clone().add(0.0, -1.0, 0.0).getBlock().getState().getType() == Material.WATER || (res = Residence.getInstance().getResidenceManager().getByLoc(loc)) != null && player != null && (!res.getPermissions().playerHas(player, Flags.tp, FlagPermissions.FlagCombo.TrueOrNone) || !res.getPermissions().playerHas(player, Flags.move, FlagPermissions.FlagCombo.TrueOrNone)) && !admin) continue;
            found = true;
            loc.add(0.5, 0.1, 0.5);
            if (Residence.getInstance().getResidenceManager().getByLoc(loc) != this) break;
            loc.add(-1.0, 0.0, -1.0);
            break;
        }
        if (!found) {
            if (Residence.getInstance().getConfigManager().getKickLocation() != null) {
                return Residence.getInstance().getConfigManager().getKickLocation();
            }
            if (!toSpawnOnFail) {
                return null;
            }
            World bw = this.getPermissions().getBukkitWorld();
            return bw != null ? (bw.getSpawnLocation() != null ? bw.getSpawnLocation() : player.getWorld().getSpawnLocation()) : player.getWorld().getSpawnLocation();
        }
        if (player != null) {
            loc.setPitch(player.getLocation().getPitch());
            loc.setYaw(player.getLocation().getYaw());
        }
        return loc;
    }

    public CuboidArea getMainArea() {
        CuboidArea area2 = this.areas.get(this.isSubzone() ? this.getResidenceName() : "main");
        if (area2 == null && !this.areas.isEmpty()) {
            return this.areas.entrySet().iterator().next().getValue();
        }
        return area2;
    }

    public CuboidArea getAreaByLoc(Location loc) {
        for (CuboidArea thisarea : this.areas.values()) {
            if (!thisarea.containsLoc(loc)) continue;
            return thisarea;
        }
        return null;
    }

    public String[] listSubzones() {
        String[] list2 = new String[this.subzones.size()];
        int i = 0;
        Iterator<String> iterator = this.subzones.keySet().iterator();
        while (iterator.hasNext()) {
            String res;
            list2[i] = res = iterator.next();
            ++i;
        }
        return list2;
    }

    public List<ClaimedResidence> getSubzones() {
        ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.subzones.entrySet()) {
            list2.add(res.getValue());
        }
        return list2;
    }

    public Map<String, ClaimedResidence> getSubzonesMap() {
        return this.subzones;
    }

    public int getSubzonesAmount(Boolean includeChild) {
        int i = 0;
        for (Map.Entry<String, ClaimedResidence> res : this.subzones.entrySet()) {
            ++i;
            if (!includeChild.booleanValue()) continue;
            i += res.getValue().getSubzonesAmount(includeChild);
        }
        return i;
    }

    public void printSubzoneList(CommandSender sender, int page) {
        PageInfo pi = new PageInfo(6, this.subzones.size(), page);
        if (!pi.isPageOk()) {
            sender.sendMessage(ChatColor.RED + Residence.getInstance().msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        Residence.getInstance().msg(sender, lm.InformationPage_TopSingle, Residence.getInstance().msg(lm.General_Subzones, new Object[0]));
        Residence.getInstance().msg(sender, lm.InformationPage_Page, Residence.getInstance().msg(lm.General_GenericPages, String.format("%d", page), pi.getTotalPages(), pi.getTotalEntries()));
        RawMessage rm = new RawMessage();
        int i = pi.getStart();
        while (i <= pi.getEnd()) {
            ClaimedResidence res = this.getSubzones().get(i);
            if (res != null) {
                rm.addText(ChatColor.GREEN + res.getResidenceName() + ChatColor.YELLOW + " - " + Residence.getInstance().msg(lm.General_Owner, res.getOwner())).addHover("Teleport to " + res.getName()).addCommand("res tp " + res.getName());
                rm.show(sender);
                rm.clear();
            }
            ++i;
        }
        pi.autoPagination(sender, "res sublist " + this.getName());
    }

    public void printAreaList(Player player, int page) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String area2 : this.areas.keySet()) {
            temp.add(area2);
        }
        Residence.getInstance().getInfoPageManager().printInfo((CommandSender)player, "res area list " + this.getName(), Residence.getInstance().msg(lm.General_PhysicalAreas, new Object[0]), temp, page);
    }

    public void printAdvancedAreaList(Player player, int page) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            CuboidArea a = entry.getValue();
            Location h = a.getHighLocation();
            Location l = a.getLowLocation();
            if (this.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.OnlyFalse)) {
                temp.add(Residence.getInstance().msg(lm.Area_ListAll, entry.getKey(), 0, 0, 0, 0, 0, 0, a.getSize()));
                continue;
            }
            temp.add(Residence.getInstance().msg(lm.Area_ListAll, entry.getKey(), h.getBlockX(), h.getBlockY(), h.getBlockZ(), l.getBlockX(), l.getBlockY(), l.getBlockZ(), a.getSize()));
        }
        Residence.getInstance().getInfoPageManager().printInfo((CommandSender)player, "res area listall " + this.getName(), Residence.getInstance().msg(lm.General_PhysicalAreas, new Object[0]), temp, page);
    }

    public String[] getAreaList() {
        String[] arealist = new String[this.areas.size()];
        int i = 0;
        for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
            arealist[i] = entry.getKey();
            ++i;
        }
        return arealist;
    }

    public int getZoneDepth() {
        int count = 0;
        ClaimedResidence res = this.getParent();
        while (res != null) {
            ++count;
            res = res.getParent();
        }
        return count;
    }

    @Deprecated
    public Location getTeleportLocation(Player player) {
        return this.getTeleportLocation(player, true);
    }

    public Location getTeleportLocation(Player player, boolean toSpawnOnFail) {
        if (this.tpLoc == null || this.getMainArea() != null && !this.containsLoc(new Location(this.getMainArea().getWorld(), this.tpLoc.getX(), this.tpLoc.getY(), this.tpLoc.getZ()))) {
            if (this.getMainArea() == null) {
                return null;
            }
            Vector low = this.getMainArea().getLowVector();
            Vector high = this.getMainArea().getHighVector();
            Location t = new Location(this.getMainArea().getWorld(), (double)((low.getBlockX() + high.getBlockX()) / 2), (double)((low.getBlockY() + high.getBlockY()) / 2), (double)((low.getBlockZ() + high.getBlockZ()) / 2));
            if ((t = this.getMiddleFreeLoc(t, player, toSpawnOnFail)) == null) {
                return null;
            }
            this.tpLoc = t.toVector();
        }
        if (this.tpLoc == null) {
            return null;
        }
        Location loc = this.tpLoc.toLocation(this.getMainArea().getLowLocation().getWorld());
        if (this.PitchYaw != null) {
            loc.setPitch((float)this.PitchYaw.getX());
            loc.setYaw((float)this.PitchYaw.getY());
        }
        return loc;
    }

    public void setTpLoc(Player player, boolean resadmin2) {
        if (!this.perms.hasResidencePermission((CommandSender)player, false) && !resadmin2) {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (!this.containsLoc(player.getLocation())) {
            Residence.getInstance().msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
            return;
        }
        this.tpLoc = player.getLocation().toVector();
        this.PitchYaw = new Vector(player.getLocation().getPitch(), player.getLocation().getYaw(), 0.0f);
        Residence.getInstance().msg((CommandSender)player, lm.Residence_SetTeleportLocation, new Object[0]);
    }

    public int isSafeTp(Player player) {
        if (player.getAllowFlight()) {
            return 0;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return 0;
        }
        if (Utils.isSpectator(player.getGameMode())) {
            return 0;
        }
        if (this.tpLoc == null) {
            return 0;
        }
        Location tempLoc = this.getTeleportLocation(player, false);
        if (tempLoc == null) {
            return 0;
        }
        int fallDistance = 0;
        int i = (int)tempLoc.getY();
        while (i >= CMIWorld.getMinHeight((World)tempLoc.getWorld())) {
            if (i == 0) {
                fallDistance = 555;
                break;
            }
            tempLoc.setY((double)i);
            Block block = tempLoc.getBlock();
            if (ResidencePlayerListener.isEmptyBlock(block)) {
                ++fallDistance;
            } else {
                if (!CMIMaterial.get((Block)block).isLava()) break;
                fallDistance = 556;
                break;
            }
            --i;
        }
        return fallDistance;
    }

    public void tpToResidence(Player reqPlayer, Player targetPlayer, boolean resadmin2) {
        int distance;
        boolean isAdmin = Residence.getInstance().isResAdminOn(reqPlayer);
        if (this.getRaid().isRaidInitialized()) {
            if (this.getRaid().isAttacker(targetPlayer) || this.getRaid().isDefender(targetPlayer) && !ConfigManager.RaidDefenderTeleport || !resadmin2) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.Raid_cantDo, new Object[0]);
                return;
            }
        } else if (!(resadmin2 || isAdmin || PermissionManager.ResPerm.bypass_tp.hasPermission((CommandSender)reqPlayer, 10000L, new String[0]) || PermissionManager.ResPerm.admin_tp.hasPermission((CommandSender)reqPlayer, 10000L, new String[0]) || this.isOwner(targetPlayer) && (!this.isOwner(targetPlayer) || !Residence.getInstance().getConfigManager().isCanTeleportIncludeOwner()))) {
            ResidencePlayer rPlayer = Residence.getInstance().getPlayerManager().getResidencePlayer(reqPlayer);
            PermissionGroup group = rPlayer.getGroup();
            if (!group.hasTpAccess()) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_TeleportDeny, new Object[0]);
                return;
            }
            if (!reqPlayer.equals(targetPlayer)) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_NoPermission, new Object[0]);
                return;
            }
            if (!this.perms.playerHas(reqPlayer, Flags.tp, FlagPermissions.FlagCombo.TrueOrNone)) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.Residence_TeleportNoFlag, new Object[0]);
                return;
            }
            if (!this.perms.playerHas(reqPlayer, Flags.move, FlagPermissions.FlagCombo.TrueOrNone)) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.Residence_MoveDeny, this.getName());
                return;
            }
        }
        ClaimedResidence old = Residence.getInstance().getTeleportMap().get(targetPlayer.getName());
        if (Bukkit.getWorld((String)this.getPermissions().getWorldName()) == null) {
            return;
        }
        if (!(old != null && old.equals(this) || (distance = this.isSafeTp(reqPlayer)) <= 6)) {
            if (distance == 556) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_TeleportConfirmLava, distance);
            } else if (distance == 555) {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_TeleportConfirmVoid, distance);
            } else {
                Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_TeleportConfirm, distance);
            }
            Residence.getInstance().getTeleportMap().put(reqPlayer.getName(), this);
            return;
        }
        boolean bypassDelay = PermissionManager.ResPerm.tpdelaybypass.hasPermission((CommandSender)targetPlayer);
        if (!(Residence.getInstance().getConfigManager().getTeleportDelay() <= 0 || isAdmin || resadmin2 || bypassDelay)) {
            Residence.getInstance().msg((CommandSender)reqPlayer, lm.General_TeleportStarted, this.getName(), Residence.getInstance().getConfigManager().getTeleportDelay());
            if (Residence.getInstance().getConfigManager().isTeleportTitleMessage()) {
                this.TpTimer(reqPlayer, Residence.getInstance().getConfigManager().getTeleportDelay());
            }
            Residence.getInstance().getTeleportDelayMap().add(reqPlayer.getName());
        }
        Location loc = this.getTeleportLocation(targetPlayer, false);
        this.finalizeTP(loc, reqPlayer, targetPlayer, resadmin2, bypassDelay);
    }

    private void finalizeTP(Location loc, Player reqPlayer, Player targetPlayer, boolean isAdmin, boolean bypassDelay) {
        if (loc == null) {
            Residence.getInstance().msg((CommandSender)reqPlayer, lm.Invalid_Location, new Object[0]);
            return;
        }
        if (Math.abs(loc.getBlockX()) > 30000000 || Math.abs(loc.getBlockZ()) > 30000000) {
            Residence.getInstance().msg((CommandSender)reqPlayer, lm.Invalid_Area, new Object[0]);
            return;
        }
        if (Residence.getInstance().getConfigManager().getTeleportDelay() > 0 && !isAdmin && !bypassDelay) {
            this.performDelaydTp(loc, targetPlayer, reqPlayer, true);
        } else {
            this.performInstantTp(loc, targetPlayer, reqPlayer, true);
        }
    }

    public void TpTimer(Player player, int t) {
        CMITitleMessage.send((Player)player, (Object)Residence.getInstance().msg(lm.General_TeleportTitle, new Object[0]), (Object)Residence.getInstance().msg(lm.General_TeleportTitleTime, t));
        CMIScheduler.runTaskLater(() -> {
            if (!Residence.getInstance().getTeleportDelayMap().contains(player.getName())) {
                return;
            }
            if (t > 1) {
                this.TpTimer(player, t - 1);
            }
        }, (long)20L);
    }

    public void performDelaydTp(Location targloc, Player targetPlayer, Player reqPlayer, boolean near) {
        ResidenceTPEvent tpevent = new ResidenceTPEvent(this, targloc, targetPlayer, reqPlayer);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)tpevent);
        if (tpevent.isCancelled()) {
            return;
        }
        CMIScheduler.runAtLocationLater((Location)targloc, () -> {
            if (targloc == null || targetPlayer == null || !targetPlayer.isOnline()) {
                return;
            }
            if (!Residence.getInstance().getTeleportDelayMap().contains(targetPlayer.getName()) && Residence.getInstance().getConfigManager().getTeleportDelay() > 0) {
                return;
            }
            if (Residence.getInstance().getTeleportDelayMap().contains(targetPlayer.getName())) {
                Residence.getInstance().getTeleportDelayMap().remove(targetPlayer.getName());
            }
            targetPlayer.closeInventory();
            CMITeleporter.teleportAsync((Entity)targetPlayer, (Location)targloc);
            if (near) {
                Residence.getInstance().msg((CommandSender)targetPlayer, lm.Residence_TeleportNear, new Object[0]);
            } else {
                Residence.getInstance().msg((CommandSender)targetPlayer, lm.General_TeleportSuccess, new Object[0]);
            }
        }, (long)((long)Residence.getInstance().getConfigManager().getTeleportDelay() * 20L));
    }

    private void performInstantTp(Location targloc, Player targetPlayer, Player reqPlayer, boolean near) {
        ResidenceTPEvent tpevent = new ResidenceTPEvent(this, targloc, targetPlayer, reqPlayer);
        Residence.getInstance().getServ().getPluginManager().callEvent((Event)tpevent);
        if (!tpevent.isCancelled()) {
            targetPlayer.closeInventory();
            try {
                if (!Version.isFolia()) {
                    targloc.getChunk().load();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (Version.isFolia()) {
                CompletableFuture future = CMITeleporter.teleportAsync((Entity)targetPlayer, (Location)targloc);
                future.thenAccept(result -> {
                    if (result.booleanValue()) {
                        if (near) {
                            Residence.getInstance().msg((CommandSender)targetPlayer, lm.Residence_TeleportNear, new Object[0]);
                        } else {
                            Residence.getInstance().msg((CommandSender)targetPlayer, lm.General_TeleportSuccess, new Object[0]);
                        }
                    }
                });
            } else {
                boolean teleported = targetPlayer.teleport(targloc);
                if (teleported) {
                    if (near) {
                        Residence.getInstance().msg((CommandSender)targetPlayer, lm.Residence_TeleportNear, new Object[0]);
                    } else {
                        Residence.getInstance().msg((CommandSender)targetPlayer, lm.General_TeleportSuccess, new Object[0]);
                    }
                }
            }
        }
    }

    public String getAreaIDbyLoc(Location loc) {
        for (Map.Entry<String, CuboidArea> area2 : this.areas.entrySet()) {
            if (!area2.getValue().containsLoc(loc)) continue;
            return area2.getKey();
        }
        return null;
    }

    public CuboidArea getCuboidAreabyName(String name) {
        for (Map.Entry<String, CuboidArea> area2 : this.areas.entrySet()) {
            if (!area2.getKey().equals(name)) continue;
            return area2.getValue();
        }
        return null;
    }

    public void removeArea(String id) {
        Residence.getInstance().getResidenceManager().removeChunkList(this.getName());
        this.areas.remove(id);
        Residence.getInstance().getResidenceManager().calculateChunks(this.getName());
    }

    public void removeArea(Player player, String id, boolean resadmin2) {
        if (this.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (!this.areas.containsKey(id)) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_NonExist, new Object[0]);
                return;
            }
            if (this.areas.size() == 1 && !Residence.getInstance().getConfigManager().allowEmptyResidences()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_RemoveLast, new Object[0]);
                return;
            }
            ResidenceAreaDeleteEvent resevent = new ResidenceAreaDeleteEvent(player, this, player == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
            Residence.getInstance().getServ().getPluginManager().callEvent((Event)resevent);
            if (resevent.isCancelled()) {
                return;
            }
            this.removeArea(id);
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_Remove, id);
            }
        } else if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        }
    }

    public Map<String, Object> save() {
        Map<String, Object> map;
        HashMap<String, Object> root = new HashMap<String, Object>();
        HashMap<String, Object> areamap = new HashMap<String, Object>();
        if (this.mainRes) {
            root.put("MainResidence", this.mainRes);
        }
        if (this.createTime != 0L) {
            root.put("CreatedOn", this.createTime);
        }
        if (this.isTopArea() && this.raid != null && this.getRaid().isUnderRaidCooldown()) {
            root.put("LastRaid", this.getRaid().getEndsAt());
        }
        if (this.isTopArea() && this.raid != null && this.getRaid().isImmune()) {
            root.put("Immunity", this.getRaid().getImmunityUntil());
        }
        try {
            if (Residence.getInstance().getConfigManager().isNewSaveMechanic()) {
                if (this.enterMessage != null || this.leaveMessage != null) {
                    MinimizeMessages min = Residence.getInstance().getResidenceManager().addMessageToTempCache(this.getWorld(), this.enterMessage, this.leaveMessage);
                    if (min == null) {
                        if (this.enterMessage != null) {
                            root.put("EnterMessage", this.enterMessage);
                        }
                        if (this.leaveMessage != null) {
                            root.put("LeaveMessage", this.leaveMessage);
                        }
                    } else if (min.getId() > 0) {
                        root.put("Messages", min.getId());
                    }
                }
            } else {
                if (this.enterMessage != null) {
                    root.put("EnterMessage", this.enterMessage);
                }
                if (this.leaveMessage != null) {
                    root.put("LeaveMessage", this.leaveMessage);
                }
            }
        }
        catch (Throwable e) {
            Bukkit.getConsoleSender().sendMessage(String.valueOf(Residence.getInstance().getPrefix()) + ChatColor.RED + " Failed to save residence (" + this.getName() + ")!");
            e.printStackTrace();
        }
        try {
            if (this.ShopDesc != null) {
                root.put("ShopDescription", this.ShopDesc);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.bank.getStoredMoneyD() != 0.0) {
            root.put("StoredMoney", this.bank.getStoredMoneyD());
        }
        if (this.BlockSellPrice != 0.0) {
            root.put("BlockSellPrice", this.BlockSellPrice);
        }
        try {
            if (!this.ChatPrefix.equals("")) {
                root.put("ChatPrefix", this.ChatPrefix);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            if (!this.ChannelColor.getName().equalsIgnoreCase(Residence.getInstance().getConfigManager().getChatColor().getName()) && !this.ChannelColor.getName().equalsIgnoreCase("WHITE")) {
                root.put("ChannelColor", this.ChannelColor.getName());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            map = this.blacklist.save();
            if (!map.isEmpty()) {
                root.put("BlackList", map);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            map = this.ignorelist.save();
            if (!map.isEmpty()) {
                root.put("IgnoreList", map);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (Residence.getInstance().getConfigManager().isNewSaveMechanic()) {
            for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
                areamap.put(entry.getKey(), entry.getValue().newSave());
            }
        } else {
            for (Map.Entry<String, CuboidArea> entry : this.areas.entrySet()) {
                areamap.put(entry.getKey(), entry.getValue().save());
            }
        }
        root.put("Areas", areamap);
        HashMap<String, Map<String, Object>> subzonemap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, ClaimedResidence> sz : this.subzones.entrySet()) {
            subzonemap.put(sz.getValue().getResidenceName(), sz.getValue().save());
        }
        if (!subzonemap.isEmpty()) {
            root.put("Subzones", subzonemap);
        }
        root.put("Permissions", this.perms.save(this.getWorld()));
        if (!this.cmdBlackList.isEmpty()) {
            root.put("cmdBlackList", this.cmdBlackList);
        }
        if (!this.cmdWhiteList.isEmpty()) {
            root.put("cmdWhiteList", this.cmdWhiteList);
        }
        try {
            if (this.tpLoc != null) {
                if (Residence.getInstance().getConfigManager().isNewSaveMechanic()) {
                    root.put("TPLoc", String.valueOf(ClaimedResidence.convertDouble(this.tpLoc.getX())) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getY()) + ":" + ClaimedResidence.convertDouble(this.tpLoc.getZ()) + ":" + ClaimedResidence.convertDouble(this.PitchYaw == null ? 0.0 : this.PitchYaw.getX()) + ":" + ClaimedResidence.convertDouble(this.PitchYaw == null ? 0.0 : this.PitchYaw.getY()));
                } else {
                    HashMap<String, Double> tpmap = new HashMap<String, Double>();
                    tpmap.put("X", ClaimedResidence.convertDouble(this.tpLoc.getX()));
                    tpmap.put("Y", ClaimedResidence.convertDouble(this.tpLoc.getY()));
                    tpmap.put("Z", ClaimedResidence.convertDouble(this.tpLoc.getZ()));
                    tpmap.put("Pitch", ClaimedResidence.convertDouble(this.PitchYaw == null ? 0.0 : this.PitchYaw.getX()));
                    tpmap.put("Yaw", ClaimedResidence.convertDouble(this.PitchYaw == null ? 0.0 : this.PitchYaw.getY()));
                    root.put("TPLoc", tpmap);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return root;
    }

    private static double convertDouble(double d) {
        return ClaimedResidence.convertDouble(String.valueOf(d));
    }

    private static double convertDouble(String dString) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.getDefault()));
        dString = dString.replace(",", ".");
        Double d = 0.0;
        try {
            d = Double.valueOf(dString);
            d = Double.valueOf(formatter.format(d));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static ClaimedResidence load(String worldName, Map<String, Object> root, ClaimedResidence parent, Residence plugin) throws Exception {
        ClaimedResidence res = new ClaimedResidence();
        if (root == null) {
            throw new Exception("Null residence!");
        }
        if (root.containsKey("CapitalizedName")) {
            res.resName = (String)root.get("CapitalizedName");
        }
        res.createTime = root.containsKey("CreatedOn") ? (Long)root.get("CreatedOn") : System.currentTimeMillis();
        if (root.containsKey("LastRaid")) {
            res.getRaid().setEndsAt((Long)root.get("LastRaid"));
        }
        if (root.containsKey("Immunity")) {
            res.getRaid().setImmunityUntil((Long)root.get("Immunity"));
        }
        if (root.containsKey("ShopDescription")) {
            res.setShopDesc((String)root.get("ShopDescription"));
        }
        if (root.containsKey("StoredMoney")) {
            if (root.get("StoredMoney") instanceof Double) {
                res.bank.setStoredMoney((Double)root.get("StoredMoney"));
            } else {
                res.bank.setStoredMoney(((Integer)root.get("StoredMoney")).intValue());
            }
        }
        if (root.containsKey("BlackList")) {
            res.blacklist = ResidenceItemList.load(plugin, res, (Map)root.get("BlackList"));
        }
        if (root.containsKey("IgnoreList")) {
            res.ignorelist = ResidenceItemList.load(plugin, res, (Map)root.get("IgnoreList"));
        }
        Map areamap = (Map)root.get("Areas");
        res.perms = ResidencePermissions.load(worldName, res, (Map)root.get("Permissions"));
        if (res.getPermissions().getOwnerLastKnownName() == null) {
            return null;
        }
        if (res.perms.getOwnerUUID() == null) {
            Bukkit.getConsoleSender().sendMessage("Failed to load residence: " + res.getName());
        }
        if (root.containsKey("MainResidence")) {
            res.mainRes = (Boolean)root.get("MainResidence");
        }
        res.BlockSellPrice = root.containsKey("BlockSellPrice") ? (Double)root.get("BlockSellPrice") : 0.0;
        World world = Residence.getInstance().getServ().getWorld(res.perms.getWorldName());
        if (world == null && !Residence.getInstance().getConfigManager().isLoadEveryWorld()) {
            throw new Exception("Cant Find World: " + res.perms.getWorldName());
        }
        for (Map.Entry map : areamap.entrySet()) {
            if (map.getValue() instanceof String) {
                res.areas.put((String)map.getKey(), CuboidArea.newLoad((String)map.getValue(), res.perms.getWorldName()));
                continue;
            }
            res.areas.put((String)map.getKey(), CuboidArea.load((Map)map.getValue(), res.perms.getWorldName()));
        }
        if (root.containsKey("Subzones")) {
            Map subzonemap = (Map)root.get("Subzones");
            for (Map.Entry map : subzonemap.entrySet()) {
                ClaimedResidence subres = ClaimedResidence.load(worldName, (Map)map.getValue(), res, plugin);
                if (subres == null) continue;
                if (subres.getResidenceName() == null) {
                    subres.setName((String)map.getKey());
                }
                if (Residence.getInstance().getConfigManager().flagsInherit()) {
                    subres.getPermissions().setParent(res.getPermissions());
                }
                if (subres.getParent() != null && !subres.getOwnerUUID().equals(subres.getParent().getOwnerUUID())) {
                    Residence.getInstance().getPlayerManager().addResidence(subres.getOwner(), subres);
                }
                res.subzones.put(((String)map.getKey()).toLowerCase(), subres);
            }
        }
        if (root.containsKey("EnterMessage") && root.get("EnterMessage") instanceof String) {
            res.enterMessage = (String)root.get("EnterMessage");
        }
        if (root.containsKey("LeaveMessage") && root.get("LeaveMessage") instanceof String) {
            res.leaveMessage = (String)root.get("LeaveMessage");
        }
        if (root.containsKey("Messages") && root.get("Messages") instanceof Integer) {
            res.enterMessage = Residence.getInstance().getResidenceManager().getChacheMessageEnter(worldName, (Integer)root.get("Messages"));
            res.leaveMessage = Residence.getInstance().getResidenceManager().getChacheMessageLeave(worldName, (Integer)root.get("Messages"));
        } else {
            PermissionGroup defaultGroup = Residence.getInstance().getPermissionManager().getDefaultGroup();
            if (defaultGroup != null) {
                if (res.enterMessage == null) {
                    res.enterMessage = defaultGroup.getDefaultEnterMessage().replace("\n", "\\n").replace("%subtitle%", "\\n");
                }
                if (res.leaveMessage == null) {
                    res.leaveMessage = defaultGroup.getDefaultLeaveMessage().replace("\n", "\\n").replace("%subtitle%", "\\n");
                }
            }
        }
        res.parent = parent;
        if (root.get("TPLoc") instanceof String) {
            String tpLoc = (String)root.get("TPLoc");
            double pitch = 0.0;
            double yaw = 0.0;
            try {
                String[] split;
                if (tpLoc.contains(",")) {
                    tpLoc = tpLoc.replace(",", ".");
                }
                if ((split = tpLoc.split(":")).length > 4) {
                    yaw = Double.parseDouble(split[4]);
                }
                if (split.length > 3) {
                    pitch = Double.parseDouble(split[3]);
                }
                res.tpLoc = new Vector(Double.parseDouble(split[0]), Double.parseDouble(split[1]), Double.parseDouble(split[2]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            res.PitchYaw = new Vector((float)pitch, (float)yaw, 0.0f);
        } else {
            Map tploc = (Map)root.get("TPLoc");
            if (tploc != null) {
                double pitch = 0.0;
                double yaw = 0.0;
                if (tploc.containsKey("Yaw")) {
                    yaw = ClaimedResidence.convertDouble(tploc.get("Yaw").toString());
                }
                if (tploc.containsKey("Pitch")) {
                    pitch = ClaimedResidence.convertDouble(tploc.get("Pitch").toString());
                }
                res.tpLoc = new Vector(ClaimedResidence.convertDouble(tploc.get("X").toString()), ClaimedResidence.convertDouble(tploc.get("Y").toString()), ClaimedResidence.convertDouble(tploc.get("Z").toString()));
                res.PitchYaw = new Vector((float)pitch, (float)yaw, 0.0f);
            }
        }
        if (root.containsKey("cmdBlackList")) {
            res.cmdBlackList = (List)root.get("cmdBlackList");
        }
        if (root.containsKey("cmdWhiteList")) {
            res.cmdWhiteList = (List)root.get("cmdWhiteList");
        }
        if (root.containsKey("ChatPrefix")) {
            res.ChatPrefix = (String)root.get("ChatPrefix");
        }
        res.ChannelColor = root.containsKey("ChannelColor") ? CMIChatColor.getColor((String)((String)root.get("ChannelColor"))) : Residence.getInstance().getConfigManager().getChatColor();
        return res;
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public boolean renameSubzone(String oldName, String newName) {
        return this.renameSubzone(null, oldName, newName, true);
    }

    public boolean renameSubzone(Player player, String oldName, String newName, boolean resadmin2) {
        if (!Residence.getInstance().validName(newName)) {
            Residence.getInstance().msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (oldName == null) {
            return false;
        }
        if (newName == null) {
            return false;
        }
        String newN = newName;
        oldName = oldName.toLowerCase();
        newName = newName.toLowerCase();
        ClaimedResidence res = this.subzones.get(oldName);
        if (res == null) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Invalid_Subzone, new Object[0]);
            }
            return false;
        }
        if (player != null && !res.getPermissions().hasResidencePermission((CommandSender)player, true) && !resadmin2) {
            Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return false;
        }
        if (this.subzones.containsKey(newName)) {
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Subzone_Exists, newName);
            }
            return false;
        }
        res.setName(newN);
        this.subzones.put(newName, res);
        this.subzones.remove(oldName);
        if (player != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Subzone_Rename, oldName, newName);
        }
        return true;
    }

    public boolean renameArea(String oldName, String newName) {
        return this.renameArea(null, oldName, newName, true);
    }

    public boolean renameArea(Player player, String oldName, String newName, boolean resadmin2) {
        if (!Residence.getInstance().validName(newName)) {
            Residence.getInstance().msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (this.getRaid().isRaidInitialized() && !resadmin2) {
            Residence.getInstance().msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return false;
        }
        if (player == null || this.perms.hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (this.areas.containsKey(newName)) {
                if (player != null) {
                    Residence.getInstance().msg((CommandSender)player, lm.Area_Exists, new Object[0]);
                }
                return false;
            }
            CuboidArea area2 = this.areas.get(oldName);
            if (area2 == null) {
                if (player != null) {
                    Residence.getInstance().msg((CommandSender)player, lm.Area_InvalidName, new Object[0]);
                }
                return false;
            }
            this.areas.put(newName, area2);
            this.areas.remove(oldName);
            if (player != null) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_Rename, oldName, newName);
            }
            return true;
        }
        Residence.getInstance().msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        return false;
    }

    public CuboidArea getArea(String name) {
        return this.areas.get(name);
    }

    public String getName() {
        String name = this.resName;
        if (this.getParent() != null) {
            name = String.valueOf(this.getParent().getName()) + "." + name;
        }
        if (name == null) {
            return "Unknown";
        }
        return name;
    }

    public void remove() {
        Residence.getInstance().getResidenceManager().removeResidence(this);
        Residence.getInstance().getResidenceManager().removeChunkList(this.getName());
        Residence.getInstance().getPlayerManager().removeResFromPlayer(this);
    }

    public ResidenceBank getBank() {
        return this.bank;
    }

    @Deprecated
    public String getWorld() {
        return this.perms.getWorldName();
    }

    @Deprecated
    public String getWorldName() {
        return this.perms.getWorldName();
    }

    public ResidencePlayer getRPlayer() {
        return Residence.getInstance().getPlayerManager().getResidencePlayer(this.getPermissions().getOwner());
    }

    public PermissionGroup getOwnerGroup() {
        return this.getRPlayer().getGroup(this.getPermissions().getWorldName());
    }

    public String getOwner() {
        return this.perms.getOwner();
    }

    public boolean isOwner(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null && player.getName().equalsIgnoreCase(name)) {
            return this.isOwner(player);
        }
        return this.perms.getOwner().equalsIgnoreCase(name);
    }

    public boolean isOwner(UUID uuid) {
        return this.perms.getOwnerUUID().toString().equals(uuid.toString());
    }

    public boolean isOwner(Player p) {
        if (p == null) {
            return false;
        }
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            return this.perms.getOwner().equalsIgnoreCase(p.getName()) || this.perms.getOwnerUUID().equals(p.getUniqueId());
        }
        return this.perms.getOwnerUUID().equals(p.getUniqueId());
    }

    public boolean isOwner(CommandSender sender) {
        if (sender instanceof Player) {
            return this.isOwner((Player)sender);
        }
        if (Residence.getInstance().getConfigManager().isOfflineMode()) {
            return this.perms.getOwner().equalsIgnoreCase(sender.getName());
        }
        return true;
    }

    public void setChatPrefix(String ChatPrefix) {
        this.ChatPrefix = ChatPrefix;
    }

    public String getChatPrefix() {
        return this.ChatPrefix == null ? "" : this.ChatPrefix;
    }

    public void setChannelColor(CMIChatColor ChannelColor) {
        this.ChannelColor = ChannelColor;
    }

    public ChatChannel getChatChannel() {
        return Residence.getInstance().getChatManager().getChannel(this.getName());
    }

    public CMIChatColor getChannelColor() {
        return this.ChannelColor;
    }

    public UUID getOwnerUUID() {
        return this.perms.getOwnerUUID();
    }

    public ResidenceItemList getItemBlacklist() {
        return this.blacklist;
    }

    public ResidenceItemList getItemIgnoreList() {
        return this.ignorelist;
    }

    public List<String> getCmdBlackList() {
        return this.cmdBlackList;
    }

    public List<String> getCmdWhiteList() {
        return this.cmdWhiteList;
    }

    public boolean addCmdBlackList(String cmd2) {
        if (cmd2.contains("/")) {
            cmd2 = cmd2.replace("/", "");
        }
        if (!this.cmdBlackList.contains(cmd2.toLowerCase())) {
            this.cmdBlackList.add(cmd2.toLowerCase());
            return true;
        }
        this.cmdBlackList.remove(cmd2.toLowerCase());
        return false;
    }

    public boolean addCmdWhiteList(String cmd2) {
        if (cmd2.contains("/")) {
            cmd2 = cmd2.replace("/", "");
        }
        if (!this.cmdWhiteList.contains(cmd2.toLowerCase())) {
            this.cmdWhiteList.add(cmd2.toLowerCase());
            return true;
        }
        this.cmdWhiteList.remove(cmd2.toLowerCase());
        return false;
    }

    public Double getBlockSellPrice() {
        return this.BlockSellPrice;
    }

    public ArrayList<Player> getPlayersInResidence() {
        ArrayList<Player> within = new ArrayList<Player>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.containsLoc(player.getLocation())) continue;
            within.add(player);
        }
        return within;
    }

    public List<ShopVote> GetShopVotes() {
        return this.ShopVoteList;
    }

    public void clearShopVotes() {
        this.ShopVoteList.clear();
    }

    public void addShopVote(List<ShopVote> ShopVotes) {
        this.ShopVoteList.addAll(ShopVotes);
    }

    public void addShopVote(ShopVote ShopVote2) {
        this.ShopVoteList.add(ShopVote2);
    }

    public Long getLeaseExpireTime() {
        return this.leaseExpireTime;
    }

    public void setLeaseExpireTime(long leaseExpireTime) {
        this.leaseExpireTime = leaseExpireTime;
    }

    public boolean kickFromResidence(Player player) {
        if (!this.containsLoc(player.getLocation())) {
            return false;
        }
        Location loc = Residence.getInstance().getConfigManager().getKickLocation();
        player.closeInventory();
        if (loc != null) {
            try {
                return CMITeleporter.teleport((Entity)player, (Location)loc);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        loc = this.getOutsideFreeLoc(player.getLocation(), player, true);
        if (loc == null) {
            return false;
        }
        try {
            return CMITeleporter.teleport((Entity)player, (Location)loc);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public ResidenceRaid getRaid() {
        if (this.raid == null) {
            this.raid = new ResidenceRaid(this);
        }
        return this.raid;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this == obj;
    }

    public Set<Signs> getSignsInResidence() {
        return this.signsInResidence;
    }

    public void setSignsInResidence(Set<Signs> signsInResidence) {
        this.signsInResidence = signsInResidence;
    }

    public double getWorthByOwner() {
        return (double)((long)((double)this.getTotalSize() * this.getOwnerGroup().getCostPerBlock() * 100.0)) / 100.0;
    }

    public double getWorth() {
        return (double)((long)((double)this.getTotalSize() * this.getBlockSellPrice() * 100.0)) / 100.0;
    }

    public void showBounds(Player player, boolean showOneTime) {
        Visualizer v = new Visualizer(player);
        v.setAreas(this.getAreaArray());
        v.setOnce(showOneTime);
        Residence.getInstance().getSelectionManager().showBounds(player, v);
    }

    public boolean isTrusted(Player player) {
        Set<String> flags2 = FlagPermissions.validFlagGroups.get(padd.groupedFlag);
        if (flags2 == null || flags2.isEmpty() || player == null) {
            return false;
        }
        boolean trusted = true;
        for (String flag : flags2) {
            Flags f = Flags.getFlag(flag);
            if (f == null) {
                trusted = false;
                break;
            }
            if (!f.isInGroup(padd.groupedFlag) || this.getPermissions().playerHas(player, f, FlagPermissions.FlagCombo.OnlyTrue)) continue;
            trusted = false;
            break;
        }
        return trusted;
    }

    @Deprecated
    public boolean isTrusted(String playerName) {
        Set<String> flags2 = FlagPermissions.validFlagGroups.get(padd.groupedFlag);
        if (flags2 == null || flags2.isEmpty() || playerName == null) {
            return false;
        }
        boolean trusted = true;
        for (String flag : flags2) {
            Flags f = Flags.getFlag(flag);
            if (f == null) {
                trusted = false;
                break;
            }
            if (!f.isInGroup(padd.groupedFlag) || this.lightWeightFlagCheck(playerName, flag)) continue;
            trusted = false;
            break;
        }
        return trusted;
    }

    private boolean lightWeightFlagCheck(String playerName, String flag) {
        Map<String, Boolean> flags2 = this.getPermissions().getPlayerFlags(playerName);
        if (flags2 == null || flags2.isEmpty() || !flags2.containsKey(flag)) {
            return false;
        }
        return flags2.get(flag);
    }

    public Set<ResidencePlayer> getTrustedPlayers() {
        HashSet<ResidencePlayer> trusted = new HashSet<ResidencePlayer>();
        for (Map.Entry<String, Map<String, Boolean>> entry : this.getPermissions().getPlayerFlags().entrySet()) {
            ResidencePlayer rp;
            if (!this.isTrusted(entry.getKey()) || (rp = ResidencePlayer.get(entry.getKey())) == null) continue;
            trusted.add(rp);
        }
        return trusted;
    }
}

