/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WorldFlagManager {
    protected Map<String, Map<String, FlagPermissions>> groupperms;
    protected Map<String, FlagPermissions> worldperms;
    protected FlagPermissions globaldefaults;
    private Residence plugin;

    public WorldFlagManager(Residence plugin) {
        this.plugin = plugin;
        this.globaldefaults = new FlagPermissions();
        this.worldperms = new HashMap<String, FlagPermissions>();
        this.groupperms = new HashMap<String, Map<String, FlagPermissions>>();
        this.parsePerms();
    }

    public FlagPermissions getPerms(Player player) {
        ResidencePlayer resPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        return this.getPerms(player.getWorld().getName(), resPlayer.getGroup().getGroupName());
    }

    public FlagPermissions getPerms(String world, String group) {
        world = world.toLowerCase();
        Map<String, FlagPermissions> groupworldperms = this.groupperms.get(group = group.toLowerCase());
        if (groupworldperms == null) {
            return this.getPerms(world);
        }
        FlagPermissions list2 = groupworldperms.get(world);
        if (list2 == null) {
            list2 = groupworldperms.get("global." + world);
            if (list2 == null) {
                list2 = groupworldperms.get("global");
            }
            if (list2 == null) {
                return this.getPerms(world);
            }
        }
        return list2;
    }

    public FlagPermissions getPerms(String world) {
        FlagPermissions list2 = this.worldperms.get(world = world.toLowerCase());
        if (list2 == null) {
            if (this.globaldefaults == null) {
                return new FlagPermissions();
            }
            return this.globaldefaults;
        }
        return list2;
    }

    public final void parsePerms() {
        block18: {
            try {
                Set keys;
                YamlConfiguration flags2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
                YamlConfiguration groups = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
                if (flags2.isConfigurationSection("Global.Flags") && (keys = flags2.getConfigurationSection("Global.Flags").getKeys(false)) != null) {
                    for (Object key : keys) {
                        if (((String)key).equalsIgnoreCase("Global")) {
                            this.globaldefaults = FlagPermissions.parseFromConfigNode((String)key, flags2.getConfigurationSection("Global.Flags"));
                            continue;
                        }
                        this.worldperms.put(((String)key).toLowerCase(), FlagPermissions.parseFromConfigNode((String)key, flags2.getConfigurationSection("Global.Flags")));
                    }
                }
                try {
                    if (flags2.isConfigurationSection("Global.CommandLimits") && (keys = flags2.getConfigurationSection("Global.CommandLimits").getKeys(false)) != null) {
                        for (Object key : keys) {
                            if (((String)key).equalsIgnoreCase("Global") && this.globaldefaults != null) {
                                this.globaldefaults.parseCommandLimits(flags2.getConfigurationSection("Global.CommandLimits." + (String)key));
                                continue;
                            }
                            FlagPermissions existing = this.worldperms.get(((String)key).toLowerCase());
                            if (existing == null) continue;
                            existing.parseCommandLimits(flags2.getConfigurationSection("Global.CommandLimits." + (String)key));
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                for (Map.Entry<String, FlagPermissions> entry : this.worldperms.entrySet()) {
                    entry.getValue().setParent(this.globaldefaults);
                }
                if (!groups.isConfigurationSection("Groups")) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "Your groups.yml file is incorrect!");
                    return;
                }
                if (!flags2.isConfigurationSection("Groups") || (keys = groups.getConfigurationSection("Groups").getKeys(false)) == null) break block18;
                for (Object key : keys) {
                    Set worldkeys;
                    if (!groups.contains("Groups." + (String)key + ".Flags") || !groups.contains("Groups." + (String)key + ".Flags.World") || key == null || (worldkeys = groups.getConfigurationSection("Groups." + (String)key + ".Flags.World").getKeys(false)) == null) continue;
                    HashMap<String, FlagPermissions> perms = new HashMap<String, FlagPermissions>();
                    for (String string : worldkeys) {
                        FlagPermissions list2 = FlagPermissions.parseFromConfigNode(string, groups.getConfigurationSection("Groups." + (String)key + ".Flags.World"));
                        if (string.equalsIgnoreCase("global")) {
                            list2.setParent(this.globaldefaults);
                            perms.put(string.toLowerCase(), list2);
                            for (Map.Entry<String, FlagPermissions> worldperm : this.worldperms.entrySet()) {
                                list2 = FlagPermissions.parseFromConfigNode(string, groups.getConfigurationSection("Groups." + (String)key + ".Flags.World"));
                                list2.setParent(worldperm.getValue());
                                perms.put("global." + worldperm.getKey().toLowerCase(), list2);
                            }
                            continue;
                        }
                        perms.put(string.toLowerCase(), list2);
                    }
                    for (Map.Entry entry : perms.entrySet()) {
                        String wkey = (String)entry.getKey();
                        FlagPermissions list3 = (FlagPermissions)entry.getValue();
                        if (wkey.startsWith("global.")) continue;
                        list3.setParent((FlagPermissions)perms.get("global." + wkey));
                        if (list3.getParent() == null) {
                            list3.setParent(this.worldperms.get(wkey));
                        }
                        if (list3.getParent() != null) continue;
                        list3.setParent(this.globaldefaults);
                    }
                    this.groupperms.put(((String)key).toLowerCase(), perms);
                }
            }
            catch (Exception ex) {
                Logger.getLogger(WorldFlagManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

