/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.commands;

import com.google.common.collect.Maps;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.commands.SubCommand;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.command.Command;
import com.lenis0012.bukkit.loginsecurity.modules.language.LanguageKeys;
import com.lenis0012.bukkit.loginsecurity.modules.storage.StorageImport;
import com.lenis0012.bukkit.loginsecurity.session.AuthService;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import com.lenis0012.bukkit.loginsecurity.session.action.ChangePassAction;
import com.lenis0012.bukkit.loginsecurity.session.action.RemovePassAction;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandAdmin
extends Command {
    private final Map<String, Method> methods = Maps.newLinkedHashMap();
    private final LoginSecurity plugin;

    public CommandAdmin(LoginSecurity plugin) {
        this.plugin = plugin;
        this.setAllowConsole(true);
        this.setPermission("loginsecurity.admin");
        this.setUsage("/lac");
        for (Method method : this.getClass().getMethods()) {
            SubCommand subCommand = method.getAnnotation(SubCommand.class);
            if (subCommand == null) continue;
            this.methods.put(subCommand.name().isEmpty() ? method.getName() : subCommand.name(), method);
        }
    }

    @Override
    public void execute() {
        String subCommand = this.getArgLength() > 0 ? this.getArg(0) : "help";
        Method method = this.methods.get(subCommand.toLowerCase());
        if (method == null) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.COMMAND_UNKNOWN).param("cmd", "/lac"), new Object[0]);
            return;
        }
        SubCommand info = method.getAnnotation(SubCommand.class);
        if (this.getArgLength() < info.minArgs() + 1) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.COMMAND_NOT_ENOUGH_ARGS).param("cmd", "/lac"), new Object[0]);
            return;
        }
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error while executing command", e);
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.COMMAND_ERROR).param("error", e.getMessage() != null ? e.getMessage() : ""), new Object[0]);
        }
    }

    @SubCommand(description="lacHelp", minArgs=-1)
    public void help() {
        this.reply("&3&lL&b&loginSecurity &3&lA&b&ldmin &3&lC&b&lommand:", new Object[0]);
        for (Map.Entry<String, Method> entry : this.methods.entrySet()) {
            String name = entry.getKey();
            SubCommand info = entry.getValue().getAnnotation(SubCommand.class);
            String usage = info.usage().isEmpty() ? "" : " " + (info.usage().startsWith("NoTrans:") ? info.usage().substring("NoTrans:".length()) : LoginSecurity.translate(info.usage()).toString());
            String desc = info.description().startsWith("NoTrans:") ? info.description().substring("NoTrans:".length()) : LoginSecurity.translate(info.description()).toString();
            this.reply("&b/lac " + name + usage + " &7- &f" + desc, new Object[0]);
        }
    }

    @SubCommand(description="lacReload")
    public void reload() {
        LoginSecurity.getConfiguration().reload();
        this.reply(true, (Object)LoginSecurity.translate(LanguageKeys.LAC_RELOAD_SUCCESS), new Object[0]);
    }

    @SubCommand(description="lacRmpass", usage="lacRmpassArgs", minArgs=1)
    public void rmpass() {
        PlayerSession session;
        String name = this.getArg(1);
        Player target = Bukkit.getPlayer((String)name);
        PlayerSession playerSession = session = target != null ? LoginSecurity.getSessionManager().getPlayerSession(target) : LoginSecurity.getSessionManager().getOfflineSession(name);
        if (!session.isRegistered()) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.LAC_NOT_REGISTERED), new Object[0]);
            return;
        }
        CommandSender admin = this.sender;
        session.performActionAsync(new RemovePassAction(AuthService.ADMIN, admin), response -> this.reply(admin, true, (Object)LoginSecurity.translate(LanguageKeys.LAC_RESET_PLAYER), new Object[0]));
    }

    @SubCommand(description="lacChangepass", usage="lacChangepassArgs", minArgs=2)
    public void changepass() {
        PlayerSession session;
        String name = this.getArg(1);
        Player target = Bukkit.getPlayer((String)name);
        PlayerSession playerSession = session = target != null ? LoginSecurity.getSessionManager().getPlayerSession(target) : LoginSecurity.getSessionManager().getOfflineSession(name);
        if (!session.isRegistered()) {
            this.reply(false, (Object)LoginSecurity.translate(LanguageKeys.LAC_NOT_REGISTERED), new Object[0]);
            return;
        }
        CommandSender admin = this.sender;
        session.performActionAsync(new ChangePassAction(AuthService.ADMIN, admin, this.getArg(2)), response -> this.reply(admin, true, (Object)LoginSecurity.translate(LanguageKeys.LAC_CHANGED_PASSWORD), new Object[0]));
    }

    @SubCommand(name="import", description="NoTrans:Import profiles into LoginSecurity", usage="NoTrans:loginsecurity", minArgs=1)
    public void importFrom() {
        String source = this.getArg(1);
        StorageImport storageImport = StorageImport.fromSourceName(source, this.sender);
        if (storageImport == null) {
            this.reply(false, (Object)("Unknown import source: " + source), new Object[0]);
            return;
        }
        this.reply(true, (Object)("Importing profiles from " + source), new Object[0]);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, (Runnable)storageImport);
    }
}

