/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater;

import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.UpdateChannel;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.updater.Updater;
import java.time.Duration;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.bukkit.plugin.Plugin;

public interface UpdaterFactory {
    public Updater getUpdater(Plugin var1);

    public boolean isCompatible(Plugin var1);

    public UpdaterFactory withChannel(UpdateChannel var1);

    public UpdaterFactory withFrequency(Duration var1);

    public Set<Capability> capabilities();

    public static UpdaterFactory provideBest(Plugin plugin, ClassLoader loader) {
        ServiceLoader<UpdaterFactory> serviceLoader = ServiceLoader.load(UpdaterFactory.class, loader);
        return StreamSupport.stream(serviceLoader.spliterator(), false).filter(factory -> factory.isCompatible(plugin)).max(Comparator.comparingInt(factory -> factory.capabilities().size())).orElseThrow(() -> new IllegalStateException("No updater implementation found"));
    }

    public static enum Capability {
        VERSION_CHECK,
        CHANNELS,
        COMPATIBILITY_CHECK,
        WEBLINK,
        DOWNLOAD,
        DEV_BUILDS;

    }
}

