/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.general;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.PlayerSession;
import org.bukkit.plugin.Plugin;

public class InventoryPacketListener
extends PacketAdapter {
    public static void register(Plugin plugin) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new InventoryPacketListener(plugin));
    }

    public InventoryPacketListener(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, new PacketType[]{PacketType.Play.Server.WINDOW_ITEMS, PacketType.Play.Server.SET_SLOT, PacketType.Play.Server.WINDOW_DATA, PacketType.Play.Client.WINDOW_CLICK});
    }

    private boolean hideInvCheck(PacketEvent event) {
        if (!LoginSecurity.getConfiguration().isHideInventory()) {
            return false;
        }
        if ((Integer)event.getPacket().getIntegers().read(0) != 0) {
            return false;
        }
        PlayerSession session = LoginSecurity.getSessionManager().getPlayerSession(event.getPlayer());
        return !session.isAuthorized() && session.isRegistered();
    }

    public void onPacketReceiving(PacketEvent event) {
        if (this.hideInvCheck(event)) {
            event.setCancelled(true);
        }
    }

    public void onPacketSending(PacketEvent event) {
        if (this.hideInvCheck(event)) {
            event.setCancelled(true);
        }
    }
}

