/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.language;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lenis0012.bukkit.loginsecurity.modules.language.TranslatedMessage;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class Translation {
    private final Map<String, String> translations = Maps.newConcurrentMap();
    private Translation fallback;
    private String name;

    public Translation(Translation fallback, Reader reader, String name) throws IOException {
        this(fallback, new JsonParser().parse(reader).getAsJsonObject(), name);
    }

    public Translation(Translation fallback, JsonObject data, String name) throws IOException {
        this.fallback = fallback;
        for (Map.Entry entry : data.entrySet()) {
            this.translations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        this.name = name.split("\\.")[0];
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.translations.get("localizedName");
    }

    public TranslatedMessage translate(String key) {
        if (this.translations.containsKey(key)) {
            return new TranslatedMessage(this.translations.get(key));
        }
        if (this.fallback != null) {
            return this.fallback.translate(key);
        }
        throw new IllegalArgumentException("Unknown translation key \"" + key + "\" for language " + this.name);
    }
}

