/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.modules.storage;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.database.InventoryRepository;
import com.lenis0012.bukkit.loginsecurity.database.LocationRepository;
import com.lenis0012.bukkit.loginsecurity.database.LoginSecurityDatabase;
import com.lenis0012.bukkit.loginsecurity.database.ProfileRepository;
import com.lenis0012.bukkit.loginsecurity.database.datasource.SingleConnectionDataSource;
import com.lenis0012.bukkit.loginsecurity.libs.pluginutils.config.CommentConfiguration;
import com.lenis0012.bukkit.loginsecurity.modules.storage.NewStorageModule;
import com.lenis0012.bukkit.loginsecurity.modules.storage.StorageImport;
import java.io.File;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LoginSecurityImport
implements StorageImport {
    private final LoginSecurity loginSecurity;
    private final CommandSender sender;

    public LoginSecurityImport(LoginSecurity loginSecurity, CommandSender sender) {
        this.loginSecurity = loginSecurity;
        this.sender = sender;
    }

    @Override
    public void run() {
        try {
            this.message("Initializing secondary import database.");
            NewStorageModule storageModule = this.loginSecurity.getModule(NewStorageModule.class);
            SingleConnectionDataSource secondaryDataSource = this.createDataSource(storageModule);
            LoginSecurityDatabase datastore = LoginSecurity.getDatastore();
            ProfileRepository profiles = new ProfileRepository(this.loginSecurity, secondaryDataSource);
            LocationRepository locations = new LocationRepository(this.loginSecurity, secondaryDataSource);
            InventoryRepository inventories = new InventoryRepository(this.loginSecurity, secondaryDataSource);
            this.message("Importing inventories.");
            datastore.getInventoryRepository().batchInsert(inventories::iterateAllBlocking);
            this.message("Importing locations.");
            datastore.getLocationRepository().batchInsert(locations::iterateAllBlocking);
            this.message("Importing profiles.");
            datastore.getProfileRepository().batchInsert(profiles::iterateAllBlocking);
            this.message("Done, imported all profiles.");
        }
        catch (SQLException e) {
            this.message("Failed to import profiles: " + e.getMessage());
        }
    }

    @Override
    public boolean isPossible() {
        NewStorageModule storageModule = this.loginSecurity.getModule(NewStorageModule.class);
        if (storageModule.getPlatform().equalsIgnoreCase("mysql")) {
            return new File(this.loginSecurity.getDataFolder(), "LoginSecurity.db").exists();
        }
        return true;
    }

    private void message(String message) {
        Bukkit.getScheduler().runTask((Plugin)this.loginSecurity, () -> this.sender.sendMessage(message));
    }

    private SingleConnectionDataSource createDataSource(NewStorageModule storageModule) {
        if (storageModule.getPlatform().equalsIgnoreCase("mysql")) {
            return new SingleConnectionDataSource((Plugin)this.loginSecurity, storageModule.createSqliteDataSource());
        }
        CommentConfiguration configuration = new CommentConfiguration(new File(this.loginSecurity.getDataFolder(), "database.yml"));
        configuration.reload();
        return new SingleConnectionDataSource((Plugin)this.loginSecurity, storageModule.createMysqlDataSource(configuration));
    }
}

