/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.session;

import com.lenis0012.bukkit.loginsecurity.LoginSecurity;
import com.lenis0012.bukkit.loginsecurity.session.AuthAction;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuthService<T> {
    public static AuthService<Player> PLAYER = new AuthService<Player>(Player.class);
    public static AuthService<CommandSender> ADMIN = new AuthService<CommandSender>(CommandSender.class);
    public static AuthService<LoginSecurity> SESSION = new AuthService<LoginSecurity>(LoginSecurity.class);
    public static AuthService<String> CHANNEL_API = new AuthService<String>(String.class);
    public static AuthService<Plugin> PLUGIN = new AuthService<Plugin>(Plugin.class);
    private final Class<T> type;

    private AuthService(Class<T> type) {
        this.type = type;
    }

    public T getProvider(AuthAction action) {
        return this.type.cast(action.getServiceProvider());
    }

    public String format(T provider) {
        if (this == PLAYER) {
            return ((Player)provider).getName();
        }
        if (this == ADMIN) {
            return ((CommandSender)provider).getName();
        }
        if (this == SESSION) {
            return "LoginSecurity";
        }
        if (this == CHANNEL_API) {
            return (String)provider;
        }
        if (this == PLUGIN) {
            return ((Plugin)provider).getName();
        }
        return provider.toString();
    }
}

