/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.loginsecurity.util;

import com.lenis0012.bukkit.loginsecurity.LoginSecurityConfig;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

public class LoggingFilter
extends AbstractFilter {
    private static final List<String> filteredWords = Arrays.asList("/register", "/login", "/changepassword", "/changepass");
    private final LoginSecurityConfig loginSecurityConfig;

    Filter.Result denyIfExposesPassword(String message) {
        if (message == null) {
            return Filter.Result.NEUTRAL;
        }
        message = message.toLowerCase();
        for (String word : filteredWords) {
            if (!message.startsWith(word) && !message.contains("issued server command: " + word)) continue;
            return Filter.Result.DENY;
        }
        if (this.loginSecurityConfig.isUseCommandShortcut()) {
            String loginShortcut = this.loginSecurityConfig.getLoginCommandShortcut().trim() + ' ';
            String registerShortcut = this.loginSecurityConfig.getRegisterCommandShortcut().trim() + ' ';
            if (message.startsWith(loginShortcut) || message.contains("issued server command: " + loginShortcut) || message.startsWith(registerShortcut) || message.contains("issued server command: " + registerShortcut)) {
                return Filter.Result.DENY;
            }
        }
        return Filter.Result.NEUTRAL;
    }

    public Filter.Result filter(LogEvent event) {
        return this.denyIfExposesPassword(event.getMessage().getFormattedMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return this.denyIfExposesPassword(msg.getFormattedMessage());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return this.denyIfExposesPassword(msg.toString());
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        return this.denyIfExposesPassword(msg);
    }

    public LoggingFilter(LoginSecurityConfig loginSecurityConfig) {
        this.loginSecurityConfig = loginSecurityConfig;
    }
}

