/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.dupe;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.dupe.MenuItemMarker;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.util.logging.Level;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DupeFixer
implements Listener {
    private final DeluxeMenus plugin;
    private final MenuItemMarker marker;

    public DupeFixer(@NotNull DeluxeMenus plugin, @NotNull MenuItemMarker marker) {
        this.plugin = plugin;
        this.marker = marker;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onPickup(@NotNull EntityPickupItemEvent event) {
        if (!this.marker.isMarked(event.getItem().getItemStack())) {
            return;
        }
        DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "Someone picked up a DeluxeMenus item. Removing it.");
        event.getItem().remove();
    }

    @EventHandler
    private void onDrop(@NotNull PlayerDropItemEvent event) {
        if (!this.marker.isMarked(event.getItemDrop().getItemStack())) {
            return;
        }
        DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "A DeluxeMenus item was dropped in the world. Removing it.");
        event.getItemDrop().remove();
    }

    @EventHandler
    private void onLogin(@NotNull PlayerLoginEvent event) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (ItemStack itemStack : event.getPlayer().getInventory().getContents()) {
                if (itemStack == null || !this.marker.isMarked(itemStack)) continue;
                DeluxeMenus.debug(DebugLevel.LOWEST, Level.INFO, "Player logged in with a DeluxeMenus item in their inventory. Removing it.");
                event.getPlayer().getInventory().remove(itemStack);
            }
        }, 10L);
    }
}

