/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.utils.SkullUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.ItemStack;

public class TextureHeadHook
implements ItemHook,
SimpleCache {
    private final Map<String, ItemStack> cache = new ConcurrentHashMap<String, ItemStack>();

    @Override
    public ItemStack getItem(String ... arguments) {
        if (arguments.length == 0) {
            return DeluxeMenus.getInstance().getHead().clone();
        }
        try {
            return this.cache.computeIfAbsent(arguments[0], key -> SkullUtils.getSkullByBase64EncodedTextureUrl(SkullUtils.getEncoded(key))).clone();
        }
        catch (Exception exception) {
            DeluxeMenus.printStacktrace("Something went wrong while trying to get texture head: " + arguments[0], exception);
            return DeluxeMenus.getInstance().getHead().clone();
        }
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

