/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.nashorn.api.tree;

import com.extendedclip.deluxemenus.libs.nashorn.api.tree.CompoundAssignmentTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ExpressionTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ExpressionTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.Tree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.TreeVisitor;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.BinaryNode;

final class CompoundAssignmentTreeImpl
extends ExpressionTreeImpl
implements CompoundAssignmentTree {
    private final ExpressionTree var;
    private final ExpressionTree expr;
    private final Tree.Kind kind;

    CompoundAssignmentTreeImpl(BinaryNode node, ExpressionTree left, ExpressionTree right) {
        super(node);
        assert (node.isAssignment()) : "not an assignment node";
        this.var = left;
        this.expr = right;
        this.kind = CompoundAssignmentTreeImpl.getOperator(node.tokenType());
        assert (this.kind != Tree.Kind.ASSIGNMENT) : "compound assignment expected";
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public ExpressionTree getVariable() {
        return this.var;
    }

    @Override
    public ExpressionTree getExpression() {
        return this.expr;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitCompoundAssignment(this, data);
    }
}

