/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.nashorn.api.tree;

import com.extendedclip.deluxemenus.libs.nashorn.api.tree.IdentifierTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ImportEntryTree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.ModuleTreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.Tree;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.TreeImpl;
import com.extendedclip.deluxemenus.libs.nashorn.api.tree.TreeVisitor;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.Module;
import java.util.List;
import java.util.stream.Collectors;

final class ImportEntryTreeImpl
extends TreeImpl
implements ImportEntryTree {
    private final long startPos;
    private final long endPos;
    private final IdentifierTree moduleRequest;
    private final IdentifierTree importName;
    private final IdentifierTree localName;

    private ImportEntryTreeImpl(long startPos, long endPos, IdentifierTree moduleRequest, IdentifierTree importName, IdentifierTree localName) {
        super(null);
        this.startPos = startPos;
        this.endPos = endPos;
        this.moduleRequest = moduleRequest;
        this.importName = importName;
        this.localName = localName;
    }

    private static ImportEntryTreeImpl createImportEntry(Module.ImportEntry entry) {
        return new ImportEntryTreeImpl(entry.getStartPosition(), entry.getEndPosition(), ModuleTreeImpl.identOrNull(entry.getModuleRequest()), ModuleTreeImpl.identOrNull(entry.getImportName()), ModuleTreeImpl.identOrNull(entry.getLocalName()));
    }

    static List<ImportEntryTreeImpl> createImportList(List<Module.ImportEntry> importList) {
        return importList.stream().map(ImportEntryTreeImpl::createImportEntry).collect(Collectors.toList());
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.IMPORT_ENTRY;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitImportEntry(this, data);
    }

    @Override
    public long getStartPosition() {
        return this.startPos;
    }

    @Override
    public long getEndPosition() {
        return this.endPos;
    }

    @Override
    public IdentifierTree getModuleRequest() {
        return this.moduleRequest;
    }

    @Override
    public IdentifierTree getImportName() {
        return this.importName;
    }

    @Override
    public IdentifierTree getLocalName() {
        return this.localName;
    }
}

