/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.libs.nashorn.internal.codegen;

import com.extendedclip.deluxemenus.libs.nashorn.internal.codegen.Compiler;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.FunctionNode;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.Node;
import com.extendedclip.deluxemenus.libs.nashorn.internal.ir.visitor.SimpleNodeVisitor;
import com.extendedclip.deluxemenus.libs.nashorn.internal.runtime.RecompilableScriptFunctionData;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;

class CacheAst
extends SimpleNodeVisitor {
    private final Deque<RecompilableScriptFunctionData> dataStack = new ArrayDeque<RecompilableScriptFunctionData>();
    private final Compiler compiler;

    CacheAst(Compiler compiler) {
        this.compiler = compiler;
        assert (!compiler.isOnDemandCompilation());
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        int id = functionNode.getId();
        this.dataStack.push(this.dataStack.isEmpty() ? this.compiler.getScriptFunctionData(id) : this.dataStack.peek().getScriptFunctionData(id));
        return true;
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        RecompilableScriptFunctionData data = this.dataStack.pop();
        if (functionNode.isSplit()) {
            data.setCachedAst(functionNode);
        }
        if (!this.dataStack.isEmpty() && (this.dataStack.peek().getFunctionFlags() & 0x10) != 0) {
            return functionNode.setBody(this.lc, functionNode.getBody().setStatements(null, Collections.emptyList()));
        }
        return functionNode;
    }
}

