/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.persistentmeta;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMetaHandler {
    @Nullable
    public PersistentDataType<?, ?> getSupportedType(@NotNull String name) {
        switch (name.toUpperCase(Locale.ROOT)) {
            case "DOUBLE": {
                return PersistentDataType.DOUBLE;
            }
            case "INTEGER": 
            case "LONG": {
                return PersistentDataType.LONG;
            }
            case "STRING": 
            case "BOOLEAN": {
                return PersistentDataType.STRING;
            }
        }
        return null;
    }

    @NotNull
    private NamespacedKey getKey(@NotNull String key) {
        NamespacedKey namespacedKey;
        if (key.contains(":")) {
            String[] split = key.split(":", 2);
            namespacedKey = new NamespacedKey(split[0], split[1]);
        } else {
            namespacedKey = new NamespacedKey((Plugin)DeluxeMenus.getInstance(), key);
        }
        return namespacedKey;
    }

    @Nullable
    public String getMeta(@NotNull Player player, @NotNull String key, @NotNull String typeName, @Nullable String defaultValue) {
        Object result;
        NamespacedKey namespacedKey;
        try {
            namespacedKey = this.getKey(key);
        }
        catch (IllegalArgumentException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to get meta value for player " + player.getName() + " with key '" + key + "' and type '" + typeName.toUpperCase(Locale.ROOT) + "'. Reason: " + e.getMessage());
            return defaultValue;
        }
        PersistentDataType<?, ?> type = this.getSupportedType(typeName);
        if (type == null) {
            return defaultValue;
        }
        try {
            result = player.getPersistentDataContainer().get(namespacedKey, type);
        }
        catch (IllegalArgumentException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to get meta value for player " + player.getName() + " with key '" + key + "' and type '" + typeName.toUpperCase(Locale.ROOT) + "'. Reason: Saved tag can not be converted to type: " + typeName.toUpperCase(Locale.ROOT));
            return defaultValue;
        }
        if (result == null) {
            return defaultValue;
        }
        return result.toString();
    }

    public boolean setMeta(@NotNull Player player, @NotNull String input) throws NumberFormatException {
        NamespacedKey namespacedKey;
        String[] args = input.split(" ", 4);
        if (args.length < 4) {
            return false;
        }
        DataAction action = DataAction.getByName(args[0]);
        if (action == null) {
            return false;
        }
        PersistentDataType<?, ?> type = this.getSupportedType(args[2]);
        if (type == null) {
            return false;
        }
        try {
            namespacedKey = this.getKey(args[1]);
        }
        catch (IllegalArgumentException e) {
            DeluxeMenus.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to set meta value for player " + player.getName() + " with key '" + args[1] + "' and type '" + args[2].toUpperCase(Locale.ROOT) + "'. Reason: " + e.getMessage());
            return false;
        }
        return this.setMeta(player, namespacedKey, type, action, args[3]);
    }

    public boolean setMeta(@NotNull Player player, @NotNull NamespacedKey key, @NotNull PersistentDataType type, @NotNull DataAction action, @NotNull String value) throws NumberFormatException {
        if (value.equalsIgnoreCase("null")) {
            player.getPersistentDataContainer().remove(key);
            return true;
        }
        switch (action) {
            case SET: {
                if (type == PersistentDataType.STRING) {
                    player.getPersistentDataContainer().set(key, type, (Object)value);
                    return true;
                }
                if (type == PersistentDataType.DOUBLE) {
                    player.getPersistentDataContainer().set(key, type, (Object)Double.parseDouble(value));
                    return true;
                }
                if (type == PersistentDataType.LONG) {
                    player.getPersistentDataContainer().set(key, type, (Object)Long.parseLong(value));
                    return true;
                }
                return false;
            }
            case REMOVE: {
                player.getPersistentDataContainer().remove(key);
                return true;
            }
            case SWITCH: {
                boolean currentValueSwitch = Boolean.parseBoolean((String)player.getPersistentDataContainer().getOrDefault(key, type, (Object)value));
                player.getPersistentDataContainer().set(key, type, (Object)String.valueOf(!currentValueSwitch));
                return true;
            }
            case ADD: {
                if (type == PersistentDataType.STRING) {
                    return false;
                }
                Object currentValueAdd = player.getPersistentDataContainer().getOrDefault(key, type, (Object)0);
                if (type == PersistentDataType.DOUBLE) {
                    double toAdd = Double.parseDouble(currentValueAdd.toString()) + Double.parseDouble(value);
                    player.getPersistentDataContainer().set(key, type, (Object)toAdd);
                    return true;
                }
                long toAddLong = Long.parseLong(currentValueAdd.toString()) + Long.parseLong(value);
                player.getPersistentDataContainer().set(key, type, (Object)toAddLong);
                return true;
            }
            case SUBTRACT: {
                if (type == PersistentDataType.STRING) {
                    return false;
                }
                Object currentValueSubtract = player.getPersistentDataContainer().getOrDefault(key, type, (Object)0);
                if (type == PersistentDataType.DOUBLE) {
                    double toSub = (Double)currentValueSubtract - Double.parseDouble(value);
                    player.getPersistentDataContainer().set(key, type, (Object)toSub);
                    return true;
                }
                long toSubLong = Long.parseLong(currentValueSubtract.toString()) - Long.parseLong(value);
                player.getPersistentDataContainer().set(key, type, (Object)toSubLong);
                return true;
            }
        }
        return false;
    }

    public static enum DataAction {
        SET,
        REMOVE,
        ADD,
        SUBTRACT,
        SWITCH;

        static final Map<String, DataAction> BY_NAME;

        @Nullable
        public static DataAction getByName(@NotNull String name) {
            return BY_NAME.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            BY_NAME = Arrays.stream(DataAction.values()).collect(Collectors.toUnmodifiableMap(Enum::name, Function.identity()));
        }
    }
}

