/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.placeholder;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Expansion
extends PlaceholderExpansion {
    private final DeluxeMenus plugin;

    public Expansion(@NotNull DeluxeMenus instance) {
        this.plugin = instance;
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        return this.plugin.getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String input) {
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return null;
        }
        Player onlinePlayer = offlinePlayer.getPlayer();
        if (onlinePlayer == null) {
            return null;
        }
        String parsedInput = PlaceholderAPI.setBracketPlaceholders((Player)onlinePlayer, (String)input);
        if (input.startsWith("meta_")) {
            String[] parts;
            String finalInput;
            if (!VersionHelper.IS_PDC_VERSION) {
                return null;
            }
            boolean isHasValueRequest = parsedInput.startsWith("meta_has_value_");
            String string = finalInput = parsedInput.startsWith("meta_has_value_") ? parsedInput.substring(15) : parsedInput.substring(5);
            if (!finalInput.contains("_")) {
                return null;
            }
            String[] stringArray = parts = isHasValueRequest ? finalInput.split("_", 2) : finalInput.split("_", 3);
            if (parts.length < 2) {
                return null;
            }
            String result = this.plugin.getPersistentMetaHandler().getMeta(onlinePlayer, parts[0], parts[1], null);
            if (isHasValueRequest) {
                return result == null ? PlaceholderAPIPlugin.booleanFalse() : PlaceholderAPIPlugin.booleanTrue();
            }
            if (result != null) {
                return result;
            }
            return parts.length > 2 ? parts[2] : "";
        }
        return null;
    }
}

