/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.updatechecker;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.Messages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class UpdateChecker
implements Listener {
    private static final TextReplacementConfig.Builder LATEST_VERSION_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<latest-version>");
    private static final TextReplacementConfig.Builder CURRENT_VERSION_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<current-version>");
    final int resourceId = 11734;
    private final DeluxeMenus plugin;
    private String latestVersion = null;
    private boolean updateAvailable = false;

    public UpdateChecker(@NotNull DeluxeMenus instance) {
        this.plugin = instance;
        new BukkitRunnable(){

            public void run() {
                if (UpdateChecker.this.check()) {
                    new BukkitRunnable(){

                        public void run() {
                            UpdateChecker.this.register();
                        }
                    }.runTask((Plugin)UpdateChecker.this.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        if (!this.updateAvailable) {
            return;
        }
        this.plugin.sms((CommandSender)player, Messages.UPDATE_AVAILABLE.message().replaceText((TextReplacementConfig)CURRENT_VERSION_REPLACER_BUILDER.replacement(this.plugin.getDescription().getVersion()).build()).replaceText((TextReplacementConfig)LATEST_VERSION_REPLACER_BUILDER.replacement(this.getLatestVersion()).build()));
    }

    private String getSpigotVersion() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=11734").openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            return new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
        }
        catch (Exception ex) {
            DeluxeMenus.debug(DebugLevel.HIGH, Level.INFO, "Failed to check for update on spigot!");
            return null;
        }
    }

    public boolean check() {
        String version = this.getSpigotVersion();
        if (version == null) {
            return false;
        }
        if (this.checkHigher(this.plugin.getDescription().getVersion(), version)) {
            this.latestVersion = version;
            this.updateAvailable = true;
            return true;
        }
        this.latestVersion = this.plugin.getDescription().getVersion();
        this.updateAvailable = false;
        return false;
    }

    public boolean updateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    private boolean checkHigher(@NotNull String currentVersion, @NotNull String newVersion) {
        return this.toReadable(currentVersion).compareTo(this.toReadable(newVersion)) < 0;
    }

    private String toReadable(@NotNull String version) {
        String[] split = Pattern.compile(".", 16).split(version.replace("v", ""));
        StringBuilder versionBuilder = new StringBuilder();
        for (String s : split) {
            versionBuilder.append(String.format("%4s", s));
        }
        return versionBuilder.toString();
    }
}

