/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import java.util.Locale;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ExpUtils {
    private ExpUtils() {
        throw new AssertionError((Object)"Util classes should not be initialized");
    }

    public static void setExp(@NotNull Player target, @NotNull String stringAmount) throws NumberFormatException {
        long amount;
        String lowerCase = stringAmount.toLowerCase(Locale.ENGLISH);
        if (stringAmount.contains("l")) {
            int neededLevel = Integer.parseInt(lowerCase.replaceAll("l", "")) + target.getLevel();
            amount = ExpUtils.getExpToLevel(neededLevel) + (ExpUtils.getTotalExperience(target) - ExpUtils.getExpToLevel(target.getLevel()));
            ExpUtils.setTotalExperience(target, 0);
        } else {
            amount = Long.parseLong(lowerCase);
        }
        if ((amount += (long)ExpUtils.getTotalExperience(target)) > Integer.MAX_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        if (amount < 0L) {
            amount = 0L;
        }
        ExpUtils.setTotalExperience(target, (int)amount);
    }

    public static void setTotalExperience(@NotNull Player player, int exp) throws IllegalArgumentException {
        if (exp < 0) {
            throw new IllegalArgumentException("Experience is negative!");
        }
        player.setExp(0.0f);
        player.setLevel(0);
        player.setTotalExperience(0);
        int amount = exp;
        while (amount > 0) {
            int expToLevel = ExpUtils.getExpAtLevel(player);
            if ((amount -= expToLevel) >= 0) {
                player.giveExp(expToLevel);
                continue;
            }
            player.giveExp(amount += expToLevel);
            amount = 0;
        }
    }

    private static int getExpAtLevel(@NotNull Player player) {
        return ExpUtils.getExpAtLevel(player.getLevel());
    }

    public static int getExpAtLevel(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getExpToLevel(int level) {
        int exp = 0;
        for (int currentLevel = 0; currentLevel < level; ++currentLevel) {
            exp += ExpUtils.getExpAtLevel(currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }

    public static int getTotalExperience(@NotNull Player player) {
        int exp = Math.round((float)ExpUtils.getExpAtLevel(player) * player.getExp());
        int currentLevel = player.getLevel();
        while (currentLevel > 0) {
            exp += ExpUtils.getExpAtLevel(--currentLevel);
        }
        if (exp < 0) {
            exp = Integer.MAX_VALUE;
        }
        return exp;
    }
}

