/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkullUtils {
    private static final Gson GSON = new Gson();

    @NotNull
    public static String getEncoded(@NotNull String url) {
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "https://textures.minecraft.net/texture/" + url).getBytes());
        return new String(encodedData);
    }

    @NotNull
    public static ItemStack getSkullByBase64EncodedTextureUrl(@NotNull String base64Url) {
        ItemStack head = DeluxeMenus.getInstance().getHead().clone();
        if (base64Url.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        if (VersionHelper.HAS_PLAYER_PROFILES) {
            PlayerProfile profile = SkullUtils.getPlayerProfile(base64Url);
            headMeta.setOwnerProfile(profile);
            head.setItemMeta((ItemMeta)headMeta);
            return head;
        }
        GameProfile profile = SkullUtils.getGameProfile(base64Url);
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            exception.printStackTrace();
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    @NotNull
    public static ItemStack getSkullByName(@NotNull String playerName) {
        ItemStack head = DeluxeMenus.getInstance().getHead().clone();
        if (playerName.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        if (!VersionHelper.IS_SKULL_OWNER_LEGACY) {
            headMeta.setOwningPlayer(offlinePlayer);
        } else {
            headMeta.setOwner(offlinePlayer.getName());
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    @NotNull
    private static GameProfile getGameProfile(@NotNull String base64Url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64Url));
        return profile;
    }

    @NotNull
    private static PlayerProfile getPlayerProfile(@NotNull String base64Url) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        String decodedBase64 = SkullUtils.decodeSkinUrl(base64Url);
        if (decodedBase64 == null) {
            return profile;
        }
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedBase64));
        }
        catch (MalformedURLException exception) {
            DeluxeMenus.printStacktrace("Something went horribly wrong trying to create basehead URL", exception);
        }
        profile.setTextures(textures);
        return profile;
    }

    @Nullable
    private static String decodeSkinUrl(@NotNull String base64Texture) {
        String decoded = new String(Base64.getDecoder().decode(base64Texture));
        JsonObject object = (JsonObject)GSON.fromJson(decoded, JsonObject.class);
        JsonElement textures = object.get("textures");
        if (textures == null) {
            return null;
        }
        JsonElement skin = textures.getAsJsonObject().get("SKIN");
        if (skin == null) {
            return null;
        }
        JsonElement url = skin.getAsJsonObject().get("url");
        return url == null ? null : url.getAsString();
    }
}

