/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final int resourceId;
    private Runnable onStart;
    private Runnable onError;
    private Runnable onNoUpdate;
    private BiConsumer<String, String> onOldVersion;

    public UpdateChecker onError(Runnable errorTask) {
        this.onError = errorTask;
        return this;
    }

    public UpdateChecker onOldVersion(BiConsumer<String, String> versionTask) {
        this.onOldVersion = versionTask;
        return this;
    }

    public UpdateChecker onNoUpdate(Runnable task) {
        this.onNoUpdate = task;
        return this;
    }

    public UpdateChecker onStart(Runnable task) {
        this.onStart = task;
        return this;
    }

    public void run() {
        String currentVersion = this.plugin.getDescription().getVersion();
        String apiUrl = "https://api.spigotmc.org/legacy/update.php?resource=";
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> {
            if (this.onStart != null) {
                this.onStart.run();
            }
            try (InputStream inputStream = new URL(apiUrl + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                String latestVersion = scanner.next();
                if (!this.isUpToDate(currentVersion, latestVersion)) {
                    this.onOldVersion.accept(currentVersion, latestVersion);
                } else {
                    this.onNoUpdate.run();
                }
            }
            catch (IOException | NoSuchElementException ex) {
                this.onError.run();
            }
        }, 3L);
    }

    private boolean isUpToDate(String currentString, String latestString) {
        try {
            String[] cParts = currentString.split(Pattern.quote("."));
            String[] lParts = latestString.split(Pattern.quote("."));
            for (int i = 0; i < cParts.length; ++i) {
                int l;
                int c = Integer.parseInt(cParts[i]);
                if (c < (l = Integer.parseInt(lParts[i]))) {
                    return false;
                }
                if (c <= l) continue;
                return true;
            }
            return lParts.length <= cParts.length;
        }
        catch (IndexOutOfBoundsException | NumberFormatException ex) {
            return true;
        }
    }

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public int getResourceId() {
        return this.resourceId;
    }
}

