/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.api;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.api.Apocalypse;
import com.ericdebouwer.zombieapocalypse.api.ZombieSpawnedEvent;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Zombie;
import org.bukkit.plugin.java.JavaPlugin;

public class ApocalypseAPI {
    private static final ApocalypseAPI instance = new ApocalypseAPI();
    private final ZombieApocalypse plugin = (ZombieApocalypse)JavaPlugin.getPlugin(ZombieApocalypse.class);

    private ApocalypseAPI() {
    }

    @Nonnull
    public static ApocalypseAPI getInstance() {
        return instance;
    }

    public boolean startApocalypse(@Nonnull String worldName) {
        return this.startApocalypse(worldName, true);
    }

    public boolean startApocalypse(@Nonnull String worldName, boolean broadCastStart) {
        return this.plugin.getApocalypseManager().startApocalypse(worldName, -1L, broadCastStart);
    }

    public boolean startApocalypse(@Nonnull String worldName, long durationMinutes) {
        Validate.isTrue((durationMinutes > 0L ? 1 : 0) != 0, (String)"duration should be a positive amount of seconds!");
        return this.plugin.getApocalypseManager().startApocalypse(worldName, Instant.now().getEpochSecond() + durationMinutes * 60L, true);
    }

    public boolean startApocalypse(@Nonnull String worldName, long durationMinutes, int mobCap, boolean broadCastStart) {
        Validate.isTrue((durationMinutes > 0L ? 1 : 0) != 0, (String)"duration should be a positive amount of seconds!");
        return this.plugin.getApocalypseManager().startApocalypse(worldName, Instant.now().getEpochSecond() + durationMinutes * 60L, mobCap, broadCastStart);
    }

    public boolean endApocalypse(@Nonnull String worldName) {
        return this.endApocalypse(worldName, true);
    }

    public boolean endApocalypse(@Nonnull String worldName, boolean broadCastEnd) {
        return this.plugin.getApocalypseManager().endApocalypse(worldName, broadCastEnd);
    }

    public boolean isApocalypse(@Nonnull String worldName) {
        return this.plugin.getApocalypseManager().isApocalypse(worldName);
    }

    public void setMobCap(@Nonnull String worldName, int mobCap) {
        this.plugin.getApocalypseManager().setMobCap(worldName, mobCap);
    }

    @Nullable
    public Apocalypse getApocalypse(@Nonnull String worldName) {
        return this.plugin.getApocalypseManager().getApoWorld(worldName).orElse(null);
    }

    @Nonnull
    public Zombie spawnZombie(@Nonnull Location location, @Nonnull ZombieType type) {
        return this.plugin.getZombieFactory().spawnZombie(location, type, ZombieSpawnedEvent.SpawnReason.API);
    }

    @Nonnull
    public Zombie spawnZombie(@Nonnull Location location) {
        return this.plugin.getZombieFactory().spawnZombie(location, ZombieSpawnedEvent.SpawnReason.API);
    }
}

