/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.apocalypse;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.api.ZombieApocalypseReloadEvent;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseManager;
import com.ericdebouwer.zombieapocalypse.config.ConfigurationManager;
import com.ericdebouwer.zombieapocalypse.config.Message;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ApocalypseCommand
implements CommandExecutor,
TabCompleter {
    private final ZombieApocalypse plugin;
    private final ConfigurationManager configManager;
    private final String START_ARG = "start";
    private final String END_ARG = "end";
    private final String MOBCAP_ARG = "setlimit";
    private final String RELOAD_ARG = "reload";
    public List<String> arguments;

    public ApocalypseCommand(ZombieApocalypse plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.arguments = Arrays.asList("start", "end", "reload", "setlimit");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Message success;
        boolean result;
        if (!sender.hasPermission("apocalypse.manage")) {
            this.configManager.sendMessage(sender, Message.NO_PERMISSION, null);
            return true;
        }
        if (args.length < 1 || !this.arguments.contains(args[0].toLowerCase())) {
            return false;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.plugin.getZombieFactory().reload();
            this.configManager.reloadConfig();
            this.plugin.getApocalypseManager().reload();
            if (this.configManager.isValid()) {
                this.configManager.sendMessage(sender, Message.RELOAD_SUCCESS, null);
            } else {
                this.configManager.sendMessage(sender, Message.RELOAD_FAIL, null);
            }
            Bukkit.getPluginManager().callEvent((Event)new ZombieApocalypseReloadEvent(this.configManager.isValid()));
            return true;
        }
        if (args.length < 2 && !(sender instanceof Player)) {
            this.configManager.sendMessage(sender, Message.NO_WORLD, null);
            return true;
        }
        String worldName = args.length < 2 ? ((Player)sender).getWorld().getName() : args[1];
        ApocalypseManager manager = this.plugin.getApocalypseManager();
        if (args[0].equalsIgnoreCase("setlimit")) {
            if (args.length < 3) {
                this.configManager.sendMessage(sender, Message.CAP_NO_ARGS, null);
                return true;
            }
            if (!manager.isApocalypse(worldName)) {
                this.configManager.sendMessage(sender, Message.CAP_NO_APOCALYPSE, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
                return true;
            }
            String lastArg = args[args.length - 1];
            try {
                int cap = Integer.parseInt(lastArg);
                manager.setMobCap(worldName, cap);
                this.configManager.sendMessage(sender, Message.CAP_SUCCESS, (ImmutableMap<String, String>)ImmutableMap.of((Object)"mobcap", (Object)lastArg, (Object)"world_name", (Object)worldName));
            }
            catch (NumberFormatException e) {
                this.configManager.sendMessage(sender, Message.CAP_INVALID_AMOUNT, (ImmutableMap<String, String>)ImmutableMap.of((Object)"input", (Object)lastArg));
            }
            return true;
        }
        if (manager.isApocalypse(worldName) == args[0].equalsIgnoreCase("start")) {
            Message fail = args[0].equalsIgnoreCase("start") ? Message.START_FAIL : Message.END_FAIL;
            this.configManager.sendMessage(sender, fail, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
            return true;
        }
        if (args[0].equalsIgnoreCase("start")) {
            long endTime = -1L;
            if (args.length >= 3) {
                try {
                    int duration = Integer.parseInt(args[2]);
                    endTime = Instant.now().getEpochSecond() + (long)duration * 60L;
                }
                catch (NumberFormatException e) {
                    this.configManager.sendMessage(sender, Message.START_INVALID_INT, (ImmutableMap<String, String>)ImmutableMap.of((Object)"input", (Object)args[2]));
                    return true;
                }
            }
            result = manager.startApocalypse(worldName, endTime, true);
        } else {
            result = manager.endApocalypse(worldName, true);
        }
        Message message = success = args[0].equalsIgnoreCase("start") ? Message.START_SUCCESS : Message.END_SUCCESS;
        if (result) {
            this.configManager.sendMessage(sender, success, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
        } else {
            this.configManager.sendMessage(sender, Message.INVALID_WORLD, (ImmutableMap<String, String>)ImmutableMap.of((Object)"world_name", (Object)worldName));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("apocalypse.manage")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.filter(this.arguments, args[0]);
        }
        if (args.length == 2) {
            List<String> worldNames = this.plugin.getServer().getWorlds().stream().map(World::getName).collect(Collectors.toList());
            return this.filter(worldNames, args[1]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("start")) {
            return this.filter(Arrays.asList("5", "10", "60", "240"), args[2]);
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("setlimit")) {
            return this.filter(Collections.singletonList("70"), args[2]);
        }
        return Collections.emptyList();
    }

    public List<String> filter(List<String> original, String query) {
        return original.stream().filter(s -> s.startsWith(query.toLowerCase())).collect(Collectors.toList());
    }
}

