/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.apocalypse;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseManager;
import com.ericdebouwer.zombieapocalypse.apocalypse.ApocalypseWorld;
import com.ericdebouwer.zombieapocalypse.config.Message;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class ApocalypseListener
implements Listener {
    private final ZombieApocalypse plugin;
    private final ApocalypseManager manager;

    public ApocalypseListener(ZombieApocalypse plugin) {
        this.plugin = plugin;
        this.manager = plugin.getApocalypseManager();
    }

    @EventHandler
    public void worldLoad(WorldLoadEvent event) {
        Optional<ApocalypseWorld> apoWorld = this.manager.getApoWorld(event.getWorld().getName());
        if (!apoWorld.isPresent()) {
            return;
        }
        event.getWorld().setMonsterSpawnLimit(apoWorld.get().getMobCap());
    }

    @EventHandler
    public void worldSwitch(PlayerChangedWorldEvent event) {
        Optional<ApocalypseWorld> apoFrom = this.manager.getApoWorld(event.getFrom().getName());
        apoFrom.ifPresent(aw -> aw.removePlayer(event.getPlayer()));
        Optional<ApocalypseWorld> apoTo = this.manager.getApoWorld(event.getPlayer().getWorld().getName());
        apoTo.ifPresent(aw -> aw.addPlayer(event.getPlayer()));
    }

    @EventHandler
    public void newPlayerJoin(PlayerJoinEvent event) {
        Optional<ApocalypseWorld> apoWorld = this.manager.getApoWorld(event.getPlayer().getWorld().getName());
        apoWorld.ifPresent(aw -> aw.addPlayer(event.getPlayer()));
    }

    @EventHandler
    public void playerLeave(PlayerQuitEvent event) {
        Optional<ApocalypseWorld> apoWorld = this.manager.getApoWorld(event.getPlayer().getWorld().getName());
        apoWorld.ifPresent(aw -> aw.removePlayer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    private void onSleep(PlayerBedEnterEvent event) {
        if (this.plugin.getConfigManager().isAllowSleep()) {
            return;
        }
        if (!this.manager.isApocalypse(event.getPlayer().getWorld().getName())) {
            return;
        }
        this.plugin.getConfigManager().sendMessage((CommandSender)event.getPlayer(), Message.NO_SLEEP, null);
        event.setCancelled(true);
    }
}

