/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.config;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.config.ConfigUpdater;
import com.ericdebouwer.zombieapocalypse.config.Message;
import com.ericdebouwer.zombieapocalypse.config.ZombieWrapper;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigurationManager {
    private final ZombieApocalypse plugin;
    private final String MESSAGES_PREFIX = "messages.";
    private final String ZOMBIES_PREFIX = "zombies.";
    private String pluginPrefix;
    private boolean checkUpdates;
    private boolean collectMetrics;
    private boolean doBabies;
    private boolean doNetherPigmen;
    private boolean burnInDay;
    private boolean blockDamage;
    private boolean doBossBar;
    private boolean bossBarFog;
    private boolean removeZombiesOnEnd;
    private boolean allowSleep;
    private boolean isValid;

    public ConfigurationManager(ZombieApocalypse plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.isValid = this.checkAndUpdateConfig();
        if (this.isValid) {
            this.loadConfig();
        }
    }

    public boolean checkAndUpdateConfig() {
        String CONFIG_NAME = "config.yml";
        File currentFile = new File(this.plugin.getDataFolder(), "config.yml");
        InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream("config.yml");
        if (templateStream == null) {
            return false;
        }
        YamlConfiguration templateConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(templateStream));
        if (this.validateSection((FileConfiguration)templateConfig, this.plugin.getConfig(), true, true)) {
            return true;
        }
        try {
            ConfigUpdater.update((Plugin)this.plugin, "config.yml", currentFile, Collections.emptyList());
        }
        catch (IOException e) {
            return false;
        }
        this.plugin.reloadConfig();
        if (this.validateSection((FileConfiguration)templateConfig, this.plugin.getConfig(), true, false)) {
            this.plugin.getLogger().info("Automatically updated old/invalid configuration file!");
            return true;
        }
        this.plugin.getLogger().warning("Automatic configuration update failed! See the header and the comments of the config.yml about fixing it");
        return false;
    }

    public void loadConfig() {
        this.pluginPrefix = this.plugin.getConfig().getString("plugin-prefix");
        this.checkUpdates = this.plugin.getConfig().getBoolean("check-for-updates", true);
        this.collectMetrics = this.plugin.getConfig().getBoolean("collect-bstats-metrics", true);
        this.doBabies = this.plugin.getConfig().getBoolean("allow-babies", true);
        this.doNetherPigmen = this.plugin.getConfig().getBoolean("spawn-pigmen-in-nether", true);
        this.burnInDay = this.plugin.getConfig().getBoolean("burn-in-day", true);
        this.blockDamage = this.plugin.getConfig().getBoolean("do-zombie-block-damage", true);
        this.doBossBar = this.plugin.getConfig().getBoolean("do-bossbar", true);
        this.bossBarFog = this.plugin.getConfig().getBoolean("bossbar-fog", true);
        this.allowSleep = this.plugin.getConfig().getBoolean("allow-sleep", true);
        this.removeZombiesOnEnd = this.plugin.getConfig().getBoolean("remove-zombies-after-apocalypse", true);
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("zombies.");
        for (String zombie : section.getKeys(false)) {
            if (!section.getBoolean(zombie + ".enabled")) continue;
            try {
                ZombieType type = ZombieType.valueOf(zombie.toUpperCase());
                ZombieWrapper wrapper = new ZombieWrapper(type, section.getConfigurationSection(zombie));
                this.plugin.getZombieFactory().addZombieWrapper(wrapper);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Zombie type '" + zombie + "' doesn't exist and isn't loaded in.");
            }
        }
    }

    public String getString(Message m) {
        String msg = this.plugin.getConfig().getString("messages." + m.getKey());
        return msg == null ? "" : msg;
    }

    public void sendMessage(CommandSender p, Message message, ImmutableMap<String, String> replacements) {
        String msg = this.getString(message);
        if (msg.isEmpty()) {
            return;
        }
        String colorMsg = ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)(this.pluginPrefix + msg));
        if (replacements != null) {
            for (Map.Entry entry : replacements.entrySet()) {
                colorMsg = colorMsg.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
            }
        }
        p.sendMessage(colorMsg);
    }

    private boolean validateSection(FileConfiguration template, FileConfiguration actual, boolean deep, boolean log) {
        if (template == null || actual == null) {
            return false;
        }
        boolean valid = true;
        for (String key : template.getKeys(deep)) {
            if (actual.getKeys(deep).contains(key) && template.get(key).getClass() == actual.get(key).getClass()) continue;
            if (log) {
                this.plugin.getLogger().log(Level.WARNING, "Missing or invalid datatype key '" + key + "' while parsing config.yml");
            }
            valid = false;
        }
        return valid;
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.isValid = this.checkAndUpdateConfig();
        if (this.isValid) {
            this.loadConfig();
        }
    }

    public boolean isCheckUpdates() {
        return this.checkUpdates;
    }

    public boolean isCollectMetrics() {
        return this.collectMetrics;
    }

    public boolean doBabies() {
        return this.doBabies;
    }

    public boolean doNetherPigmen() {
        return this.doNetherPigmen;
    }

    public boolean isBurnInDay() {
        return this.burnInDay;
    }

    public boolean isBlockDamage() {
        return this.blockDamage;
    }

    public boolean doBossBar() {
        return this.doBossBar;
    }

    public boolean isBossBarFog() {
        return this.bossBarFog;
    }

    public boolean isRemoveZombiesOnEnd() {
        return this.removeZombiesOnEnd;
    }

    public boolean isAllowSleep() {
        return this.allowSleep;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

