/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.zombie;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.config.Message;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ZombieCommand
implements CommandExecutor,
TabCompleter {
    private final ZombieApocalypse plugin;
    private final String EGG_ARG = "egg";
    private final String SPAWNER_ARG = "spawner";
    private final List<String> arguments = Arrays.asList("egg", "spawner");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ZombieType type;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be run by a player!");
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("apocalypse.zombie")) {
            this.plugin.getConfigManager().sendMessage((CommandSender)player, Message.NO_PERMISSION, null);
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        if (!this.arguments.contains(args[0].toLowerCase())) {
            return false;
        }
        try {
            type = ZombieType.valueOf(args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getConfigManager().sendMessage((CommandSender)player, Message.INVALID_ZOMBIE, (ImmutableMap<String, String>)ImmutableMap.of((Object)"input", (Object)args[1]));
            return true;
        }
        ItemStack zombieItem = args[0].equalsIgnoreCase("spawner") ? this.plugin.getZombieItems().getSpawner(type) : this.plugin.getZombieItems().getSpawnEgg(type);
        player.getInventory().addItem(new ItemStack[]{zombieItem});
        this.plugin.getConfigManager().sendMessage((CommandSender)player, Message.ITEM_GIVEN, (ImmutableMap<String, String>)ImmutableMap.of((Object)"item_name", (Object)zombieItem.getItemMeta().getDisplayName()));
        return true;
    }

    private List<String> filter(List<String> original, String query) {
        return original.stream().filter(s -> s.startsWith(query.toLowerCase())).collect(Collectors.toList());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("apocalypse.zombie")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.filter(this.arguments, args[0]);
        }
        if (args.length == 2) {
            return this.filter(Stream.of(ZombieType.values()).map(t -> t.toString().toLowerCase()).collect(Collectors.toList()), args[1]);
        }
        return Collections.emptyList();
    }

    public ZombieCommand(ZombieApocalypse plugin) {
        this.plugin = plugin;
    }
}

