/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.zombie;

import com.ericdebouwer.zombieapocalypse.ZombieApocalypse;
import com.ericdebouwer.zombieapocalypse.zombie.ZombieType;
import javax.annotation.Nullable;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ZombieItems {
    private final NamespacedKey key;

    public ZombieItems(ZombieApocalypse plugin) {
        this.key = new NamespacedKey((Plugin)plugin, "ZombieType");
    }

    protected ItemStack createZombieItem(String name, Material mat, ZombieType type) {
        ItemStack zombieItem = new ItemStack(mat);
        ItemMeta meta = zombieItem.getItemMeta();
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)type.toString());
        String itemName = WordUtils.capitalizeFully((String)type.toString()) + name;
        meta.setDisplayName(ChatColor.RESET + "" + ChatColor.WHITE + itemName);
        zombieItem.setItemMeta(meta);
        return zombieItem;
    }

    public ItemStack getSpawnEgg(ZombieType type) {
        return this.createZombieItem(" Zombie Egg", Material.ZOMBIE_SPAWN_EGG, type);
    }

    public ItemStack getSpawner(ZombieType type) {
        return this.createZombieItem(" Zombie Spawner", Material.SPAWNER, type);
    }

    @Nullable
    public ZombieType getZombieType(PersistentDataHolder container) {
        if (container == null) {
            return null;
        }
        try {
            return ZombieType.valueOf((String)container.getPersistentDataContainer().get(this.key, PersistentDataType.STRING));
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return null;
        }
    }

    public NamespacedKey getKey() {
        return this.key;
    }
}

