/*
 * Decompiled with CFR 0.152.
 */
package com.ericdebouwer.zombieapocalypse.zombie;

import javax.annotation.Nullable;
import org.bukkit.entity.Zombie;

public enum ZombieType {
    DEFAULT,
    SPRINTER,
    BOOMER,
    THROWER,
    TANK,
    NINJA,
    MULTIPLIER,
    JUMPER,
    PILLAR;

    private static final String ZOMBIE_IDENTIFIER = "ApocalypseZombieType";

    @Nullable
    public static ZombieType getType(Zombie zombie) {
        for (String tag : zombie.getScoreboardTags()) {
            if (!tag.startsWith(ZOMBIE_IDENTIFIER)) continue;
            try {
                String type = tag.replaceFirst(ZOMBIE_IDENTIFIER, "");
                return ZombieType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                return DEFAULT;
            }
        }
        return null;
    }

    public Zombie set(Zombie zombie) {
        String type = ZOMBIE_IDENTIFIER + this.toString();
        zombie.getScoreboardTags().add(type);
        return zombie;
    }
}

