/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.google.gson.Gson;
import com.handy.playertitle.constants.BuffType;
import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.constants.PotionEffectNameEnum;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.lib.attribute.PotionEffectParam;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleBuffService;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class BuffCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "buff";
    }

    @Override
    public String permission() {
        return "playerTitle.buff";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer titleId = AssertUtil.isNumericToInt(args[2], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "buff")) {
            case BUFF_ADD_BUFF: {
                AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                BuffType buffType = BuffType.getType(args[3]);
                AssertUtil.notNull(buffType, sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
                TitleBuff titleBuff = new TitleBuff();
                titleBuff.setTitleId(titleId);
                titleBuff.setBuffType(buffType.getBuffType());
                if (BuffTypeEnum.MMO_ITEMS.getBuffType().equals(buffType.getBuffType())) {
                    MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("buffTypeFailureMsg"));
                    return;
                }
                if (BuffTypeEnum.POTION_EFFECT.getBuffType().equals(buffType.getBuffType())) {
                    AssertUtil.notTrue(args.length < 6, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                    String type = args[4];
                    String[] split = type.trim().split("\\(");
                    type = split[0];
                    PotionEffectParam potionEffectParam = new PotionEffectParam();
                    potionEffectParam.setPotionName(type);
                    potionEffectParam.setPotionChinesizationName(PotionEffectNameEnum.getPotionEffectName(type));
                    Integer amount = NumberUtil.isNumericToInt(args[5]);
                    AssertUtil.notTrue(amount == null || amount < 0, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
                    potionEffectParam.setPotionLevel(amount);
                    potionEffectParam.setPotionHide(args.length == 7 && "true".equals(args[6]));
                    titleBuff.setBuffContent(new Gson().toJson((Object)potionEffectParam));
                    boolean rst = TitleBuffService.getInstance().add(titleBuff);
                    MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                    return;
                }
                AssertUtil.notTrue(args.length < 5, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                titleBuff.setBuffContent(StrUtil.replaceSpace(args[4]));
                titleBuff.setDescription(args.length > 5 ? StrUtil.replaceSpace(args[5]) : null);
                boolean rst = TitleBuffService.getInstance().add(titleBuff);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                break;
            }
            case BUFF_DELETE_BUFF: {
                boolean rst = TitleBuffService.getInstance().removeByTitleId(titleId);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                break;
            }
            case BUFF_EDIT_BUFF: {
                AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                boolean rst = TitleBuffService.getInstance().editById(titleId, args[3]);
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor(rst ? "succeedMsg" : "failureMsg"));
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("typeFailureMsg"));
            }
        }
    }
}

