/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.core;

import com.handy.playertitle.constants.BuffTypeEnum;
import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.event.PlayerTitleBuffEvent;
import com.handy.playertitle.lib.attribute.AttributeEnum;
import com.handy.playertitle.lib.attribute.AttributeUtil;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BuffManageUtil {
    private BuffManageUtil() {
    }

    public static BuffManageUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void addBuff(Player player, List<TitleBuff> titleBuffs) {
        if (CollUtil.isEmpty(titleBuffs)) {
            return;
        }
        List disabledBuffWorldList = ConfigUtil.CONFIG.getStringList("disabledBuffWorld");
        if (CollUtil.isNotEmpty(disabledBuffWorldList = disabledBuffWorldList.stream().filter(StrUtil::isNotEmpty).collect(Collectors.toList())) && disabledBuffWorldList.contains(player.getWorld().getName())) {
            return;
        }
        ArrayList<String> apList = new ArrayList<String>();
        ArrayList<String> asList = new ArrayList<String>();
        ArrayList<String> sxList = new ArrayList<String>();
        ArrayList<String> mmoList = new ArrayList<String>();
        ArrayList<String> peList = new ArrayList<String>();
        ArrayList<String> myList = new ArrayList<String>();
        for (TitleBuff titleBuff : titleBuffs) {
            BuffTypeEnum buffTypeEnum = BuffTypeEnum.getEnum(titleBuff.getBuffType());
            if (buffTypeEnum == null) continue;
            switch (buffTypeEnum) {
                case ATTRIBUTE_PLUS: {
                    apList.add(titleBuff.getBuffContent());
                    break;
                }
                case SX_ATTRIBUTE: {
                    sxList.add(titleBuff.getBuffContent());
                    break;
                }
                case POTION_EFFECT: {
                    peList.add(titleBuff.getBuffContent());
                    break;
                }
                case MMO_ITEMS: {
                    mmoList.add(titleBuff.getBuffContent());
                    break;
                }
                case ATTRIBUTE_SYSTEM: {
                    asList.add(titleBuff.getBuffContent());
                    break;
                }
                case MYTHIC_LIB: {
                    myList.add(titleBuff.getBuffContent());
                    break;
                }
            }
        }
        if (CollUtil.isNotEmpty(apList)) {
            AttributeUtil.getInstance().addAttribute(player, apList, AttributeEnum.ATTRIBUTE_PLUS);
        }
        if (CollUtil.isNotEmpty(sxList)) {
            AttributeUtil.getInstance().addAttribute(player, sxList, AttributeEnum.SX_ATTRIBUTE);
        }
        if (CollUtil.isNotEmpty(peList)) {
            AttributeUtil.getInstance().addAttribute(player, peList, AttributeEnum.POTION_EFFECT);
        }
        if (CollUtil.isNotEmpty(mmoList)) {
            AttributeUtil.getInstance().addAttribute(player, mmoList, AttributeEnum.MMO_ITEMS);
        }
        if (CollUtil.isNotEmpty(asList)) {
            AttributeUtil.getInstance().addAttribute(player, asList, AttributeEnum.ATTRIBUTE_SYSTEM);
        }
        if (CollUtil.isNotEmpty(myList)) {
            AttributeUtil.getInstance().addAttribute(player, myList, AttributeEnum.MYTHIC_LIB);
        }
    }

    public void removeBuff(Player player) {
        AttributeUtil.getInstance().removeAttribute(player, AttributeEnum.ALL);
    }

    public void setBuff(Player player, List<TitleBuff> titleBuffs) {
        this.removeBuff(player);
        this.addBuff(player, titleBuffs);
    }

    public void callBuffEvent(Player player) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerTitleBuffEvent(player)));
    }

    private static class SingletonHolder {
        private static final BuffManageUtil INSTANCE = new BuffManageUtil();

        private SingletonHolder() {
        }
    }
}

