/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.core.particle;

import com.handy.playertitle.constants.ParticleTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.core.particle.PlayerParticlesUtil;
import com.handy.playertitle.core.particle.SuperTrailsProUtil;
import com.handy.playertitle.core.particle.SuperTrailsUtil;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.service.TitleParticleService;
import java.util.Optional;
import org.bukkit.entity.Player;

public class ParticleManageUtil {
    public static void setParticle(Player player) {
        ParticleManageUtil.removeParticle(player);
        ParticleManageUtil.addParticle(player);
    }

    private static void addParticle(Player player) {
        TitlePlayer titlePlayer = TitleConstants.TITLE_PLAYER_PARTICLE_MAP.get(player.getUniqueId());
        if (titlePlayer == null) {
            return;
        }
        Optional<TitleParticle> titleParticleOptional = TitleParticleService.getInstance().findByTitleId(titlePlayer.getTitleId());
        if (!titleParticleOptional.isPresent()) {
            return;
        }
        TitleParticle titleParticle = titleParticleOptional.get();
        ParticleTypeEnum particleTypeEnum = ParticleTypeEnum.getEnum(titleParticle.getParticleType());
        switch (particleTypeEnum) {
            case SUPER_TRAILS: {
                SuperTrailsUtil.getInstance().addAttribute(player, titleParticle);
                break;
            }
            case SUPER_TRAILS_PRO: {
                SuperTrailsProUtil.getInstance().addAttribute(player, titleParticle);
                break;
            }
            case PLAYER_PARTICLES: {
                PlayerParticlesUtil.getInstance().addAttribute(player, titleParticle);
                break;
            }
        }
    }

    private static void removeParticle(Player player) {
        SuperTrailsProUtil.getInstance().removeAttribute(player);
        SuperTrailsUtil.getInstance().removeAttribute(player);
        PlayerParticlesUtil.getInstance().removeAttribute(player);
    }
}

