/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.inventory;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.db.enter.Page;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ViewOpenGui {
    private static final ViewOpenGui INSTANCE = new ViewOpenGui();

    private ViewOpenGui() {
    }

    public static ViewOpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(String playerName) {
        String title = ConfigUtil.OPEN_CONFIG.getString("viewTitle", "");
        title = StrUtil.replace(title, "player", playerName);
        Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(playerName);
        if (onlinePlayerOpt.isPresent()) {
            title = PlaceholderApiUtil.set(onlinePlayerOpt.get(), title);
        }
        int size = ConfigUtil.OPEN_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_OPEN.getType(), title, size);
        handyInventory.setSearchType(playerName);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    public void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.OPEN_CONFIG.getString("open.index"));
        handyInventory.setPageSize(indexList.size());
        Page<TitlePlayer> page = TitlePlayerService.getInstance().findPageByPlayerName(handyInventory.getSearchType(), handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String materialStr = ConfigUtil.OPEN_CONFIG.getString("open.material");
        String useMaterial = ConfigUtil.OPEN_CONFIG.getString("open.useMaterial");
        int customModelDataId = ConfigUtil.OPEN_CONFIG.getInt("open.custom-model-data");
        int i = 0;
        for (TitlePlayer titlePlayer : page.getRecords()) {
            List<String> loreList = ConfigUtil.OPEN_CONFIG.getStringList("open.viewLore");
            String titleMaterial = ConfigUtil.MATERIAL_CONFIG.getString(titlePlayer.getTitleId().toString(), materialStr);
            String material = TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL) ? useMaterial : titleMaterial;
            HashMap<String, List<String>> replaceBatchMap = MapUtil.newHashMapWithExpectedSize(3);
            replaceBatchMap.put("description", TitleUtil.getDescription(titlePlayer.getDescription()));
            replaceBatchMap.put("buff", TitleUtil.getBuff(titlePlayer.getTitleBuffs()));
            replaceBatchMap.put("particle", TitleUtil.getParticle(titlePlayer.getTitleParticle()));
            Map<String, String> replaceMap = this.getReplaceOpenLoreMap(titlePlayer, Bukkit.getPlayer((String)handyInventory.getSearchType()));
            loreList = ItemStackUtil.loreReplaceMap(loreList, replaceMap);
            loreList = ItemStackUtil.loreBatchReplaceMap(loreList, replaceBatchMap, BaseUtil.getLangMsg("not"));
            int titleCustomModelDataId = ConfigUtil.MATERIAL_CONFIG.getInt(titlePlayer.getTitleId() + "_custom-model-data", customModelDataId);
            String titleName = PlaceholderApiUtil.set(Bukkit.getPlayer((String)handyInventory.getSearchType()), titlePlayer.getTitleName());
            loreList = PlaceholderApiUtil.set(Bukkit.getPlayer((String)handyInventory.getSearchType()), loreList);
            ItemStack itemStack = ItemStackUtil.getItemStack(material, titleName, loreList, TitleUtil.isUse(titlePlayer, TitleUseTypeEnum.ALL), titleCustomModelDataId);
            Integer index = indexList.get(i++);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, titlePlayer.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.OPEN_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setCustomButton(ConfigUtil.OPEN_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> getReplaceOpenLoreMap(TitlePlayer titlePlayer, Player player) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        map.put("id", titlePlayer.getTitleId().toString());
        String titleName = PlaceholderApiUtil.set(player, titlePlayer.getTitleName());
        map.put("titleName", titleName);
        map.put("expirationTime", DateUtil.format(titlePlayer.getExpirationTime(), "yyyy-MM-dd"));
        if (DateUtil.isPerpetual(titlePlayer.getExpirationTime())) {
            map.put("expirationTime", BaseUtil.getLangMsg("perpetual"));
        }
        int haveCount = TitlePlayerService.getInstance().findCount(titlePlayer.getTitleId());
        map.put("haveCount", String.valueOf(haveCount));
        return map;
    }
}

