/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.attribute;

import com.handy.playertitle.lib.InitApi;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MythicLibUtil {
    private static Boolean IS_NEW_VERSION;

    private MythicLibUtil() {
    }

    protected static void addAttribute(Player player, List<String> attributeList) {
        MMOPlayerData playerData = MMOPlayerData.get((UUID)player.getUniqueId());
        for (String attribute : attributeList) {
            String[] split = attribute.split(":");
            String attributeName = split[0].trim();
            String attributeValue = split[1].trim();
            StatModifier experienceModifier = new StatModifier(InitApi.PLUGIN.getName(), BaseUtil.stripColor(attributeName).toUpperCase().replace("-", "_"), NumberUtil.isNumericToDouble(attributeValue, 0.0).doubleValue(), ModifierType.FLAT);
            experienceModifier.register(playerData);
        }
    }

    protected static void removeAttribute(Player player) {
        MMOPlayerData playerData = MMOPlayerData.get((UUID)player.getUniqueId());
        StatMap statMap = playerData.getStatMap();
        for (StatInstance instance : statMap.getInstances()) {
            instance.removeIf(i -> i.equals(InitApi.PLUGIN.getName()));
        }
    }

    protected static boolean isNewVersion() {
        if (IS_NEW_VERSION != null) {
            return IS_NEW_VERSION;
        }
        try {
            Class.forName("io.lumine.mythic.lib.api.player.MMOPlayerData");
            IS_NEW_VERSION = true;
        }
        catch (ClassNotFoundException e) {
            IS_NEW_VERSION = false;
        }
        return IS_NEW_VERSION;
    }
}

